/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.PowerHandler;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.IStillManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MachineStill
extends TilePowered
implements ISpecialInventory,
ISidedInventory,
ILiquidTankContainer {
    public static final short SLOT_PRODUCT = 0;
    public static final short SLOT_RESOURCE = 1;
    public static final short SLOT_CAN = 2;
    @EntityNetData
    public ForestryTank resourceTank = new ForestryTank(10000);
    @EntityNetData
    public ForestryTank productTank = new ForestryTank(10000);
    private InventoryAdapter inventory = new InventoryAdapter(3, "Items");
    private Recipe currentRecipe;
    private FluidStack bufferedLiquid;
    public int distillationTime = 0;
    public int distillationTotalTime = 0;

    public MachineStill() {
        this.setHints((String[])Config.hints.get("still"));
    }

    @Override
    public String func_70303_b() {
        return "factory.6";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.StillGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    protected void configurePowerProvider(PowerHandler provider) {
        provider.configure(50.0f, 110.0f, 5.0f, 800.0f);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("DistillationTime", this.distillationTime);
        nbttagcompound.func_74768_a("DistillationTotalTime", this.distillationTotalTime);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        NBTTagCompound NBTproductSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        this.productTank.writeToNBT(NBTproductSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        nbttagcompound.func_74782_a("ProductTank", (NBTBase)NBTproductSlot);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.distillationTime = nbttagcompound.func_74762_e("DistillationTime");
        this.distillationTotalTime = nbttagcompound.func_74762_e("DistillationTotalTime");
        this.resourceTank = new ForestryTank(10000);
        this.productTank = new ForestryTank(10000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
            this.productTank.readFromNBT(nbttagcompound.func_74775_l("ProductTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        FluidContainerRegistry.FluidContainerData container;
        if (this.inventory.func_70301_a(2) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.func_70301_a(2))) != null && RecipeManager.isInput(container.fluid)) {
            this.inventory.func_70299_a(2, StackUtils.replenishByContainer(this, this.inventory.func_70301_a(2), container, this.resourceTank));
            if (this.inventory.func_70301_a((int)2).field_77994_a <= 0) {
                this.inventory.func_70299_a(2, null);
            }
        }
        if (this.inventory.func_70301_a(1) != null && (container = LiquidHelper.getEmptyContainer(this.inventory.func_70301_a(1), this.productTank.getFluid())) != null) {
            this.inventory.func_70299_a(0, this.bottleIntoContainer(this.inventory.func_70301_a(1), this.inventory.func_70301_a(0), container, this.productTank));
            if (this.inventory.func_70301_a((int)1).field_77994_a <= 0) {
                this.inventory.func_70299_a(1, null);
            }
        }
        if (this.field_70331_k.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean workCycle() {
        this.checkRecipe();
        if (this.distillationTime > 0 && this.currentRecipe != null) {
            this.distillationTime -= this.currentRecipe.input.amount;
            this.addProduct(this.currentRecipe.output.fluidID, this.currentRecipe.output.amount);
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        if (this.currentRecipe != null && this.productTank.getFluidAmount() + this.currentRecipe.output.amount <= 10000) {
            int resReq = this.currentRecipe.timePerUnit * this.currentRecipe.input.amount;
            if (this.resourceTank.getFluidAmount() >= resReq) {
                this.distillationTime = this.distillationTotalTime = resReq;
                this.resourceTank.drain(resReq, true);
                this.bufferedLiquid = new FluidStack(this.currentRecipe.input.fluidID, resReq);
                this.setErrorState(EnumErrorCode.OK);
                return true;
            }
            this.setErrorState(EnumErrorCode.NORESOURCE);
        }
        this.bufferedLiquid = null;
        return false;
    }

    private void addProduct(int id, int amount) {
        this.productTank.fill(new FluidStack(id, amount), true);
    }

    public void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.resourceTank.getFluid());
        if (sameRec == null && this.bufferedLiquid != null && this.distillationTime > 0) {
            sameRec = RecipeManager.findMatchingRecipe(new FluidStack(this.bufferedLiquid.fluidID, this.distillationTime));
        }
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
    }

    @Override
    public boolean isWorking() {
        return this.distillationTime > 0 || this.currentRecipe != null && this.productTank.getFluidAmount() + this.currentRecipe.output.amount <= 10000;
    }

    @Override
    public boolean hasWork() {
        if (this.currentRecipe == null) {
            return false;
        }
        return (this.distillationTime > 0 || this.resourceTank.getFluidAmount() >= this.currentRecipe.timePerUnit * this.currentRecipe.input.amount) && this.productTank.getFluidAmount() <= this.productTank.getCapacity() - this.currentRecipe.output.amount;
    }

    public int getDistillationProgressScaled(int i) {
        if (this.distillationTotalTime == 0) {
            return i;
        }
        return this.distillationTime * i / this.distillationTotalTime;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public int getProductScaled(int i) {
        return this.productTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getProductScaled(100));
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.distillationTime = j;
                break;
            }
            case 1: {
                this.distillationTotalTime = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.distillationTime);
        iCrafting.func_71112_a(container, 1, this.distillationTotalTime);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        int inventorySlot;
        FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container != null && RecipeManager.isInput(container.fluid)) {
            inventorySlot = 2;
        } else if (LiquidHelper.isEmptyContainer(stack)) {
            inventorySlot = 1;
        } else {
            return 0;
        }
        return this.inventory.addStack(stack, inventorySlot, 1, false, doAdd);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ItemStack product = null;
        if (this.inventory.func_70301_a(0) != null) {
            product = new ItemStack(this.inventory.func_70301_a((int)0).field_77993_c, 1, this.inventory.func_70301_a(0).func_77960_j());
            if (doRemove) {
                this.inventory.func_70298_a(0, 1);
            }
        }
        if (product != null) {
            return new ItemStack[]{product};
        }
        return StackUtils.EMPTY_STACK_ARRAY;
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 0;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 1) {
            return LiquidHelper.isEmptyContainer(itemstack);
        }
        if (slotIndex == 2) {
            FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(itemstack);
            return container != null && RecipeManager.isInput(container.fluid);
        }
        return false;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!RecipeManager.isInput(resource)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.productTank.drain(quantityMax, doEmpty);
    }

    @Override
    public ForestryTank[] getTanks() {
        return new ForestryTank[]{this.resourceTank, this.productTank};
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class RecipeManager
    implements IStillManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerUnit, FluidStack input, FluidStack output) {
            recipes.add(new Recipe(timePerUnit, input, output));
        }

        public static Recipe findMatchingRecipe(FluidStack item) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(item)) continue;
                return recipe;
            }
            return null;
        }

        public static boolean isInput(FluidStack res) {
            return RecipeManager.findMatchingRecipe(res) != null;
        }

        @Override
        public Map getRecipes() {
            HashMap<Object[], Object[]> recipeList = new HashMap<Object[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(new Object[]{recipe.input}, new Object[]{recipe.output});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final int timePerUnit;
        public final FluidStack input;
        public final FluidStack output;

        public Recipe(int timePerUnit, FluidStack input, FluidStack output) {
            this.timePerUnit = timePerUnit;
            if (input == null) {
                throw new IllegalArgumentException("Still recipes need an input. Input was null.");
            }
            if (output == null) {
                throw new IllegalArgumentException("Still recipes need an output. Output was null.");
            }
            this.input = input;
            this.output = output;
        }

        public boolean matches(FluidStack res) {
            if (res == null && this.input == null) {
                return true;
            }
            if (res == null && this.input != null) {
                return false;
            }
            if (res != null && this.input == null) {
                return false;
            }
            return this.input.isFluidEqual(res);
        }
    }
}

