/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.power.PowerHandler;
import forestry.api.core.ForestryAPI;
import forestry.api.recipes.ISqueezerManager;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.gadgets.TilePowered;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.triggers.ForestryTrigger;
import forestry.core.triggers.Trigger;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.Utils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MachineSqueezer
extends TilePowered
implements ISpecialInventory,
ISidedInventory,
ILiquidTankContainer {
    private static final short SLOT_RESOURCE_1 = 0;
    private static final short SLOTS_RESOURCE_COUNT = 9;
    private static final short SLOT_REMNANT = 9;
    private static final short SLOT_CAN_INPUT = 10;
    private static final short SLOT_CAN_OUTPUT = 11;
    @EntityNetData
    public ForestryTank productTank = new ForestryTank(10000);
    private InventoryAdapter inventory = new InventoryAdapter(12, "Items");
    private Recipe currentRecipe;
    private Stack pendingLiquids = new Stack();
    private Stack pendingRemnants = new Stack();
    private int productionTime;
    private int timePerItem;

    public MachineSqueezer() {
        this.setHints((String[])Config.hints.get("squeezer"));
    }

    @Override
    public String func_70303_b() {
        return "factory.5";
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.SqueezerGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    protected void configurePowerProvider(PowerHandler provider) {
        provider.configure(50.0f, 110.0f, 5.0f, 400.0f);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("ProductionTime", this.productionTime);
        nbttagcompound.func_74768_a("TimePerItem", this.timePerItem);
        this.inventory.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        ItemStack[] remnants = this.pendingRemnants.toArray(new ItemStack[this.pendingRemnants.size()]);
        for (int i = 0; i < remnants.length; ++i) {
            if (remnants[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            remnants[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingRemnants", (NBTBase)nbttaglist);
        nbttaglist = new NBTTagList();
        FluidStack[] liquids = this.pendingLiquids.toArray(new FluidStack[this.pendingLiquids.size()]);
        for (int i = 0; i < liquids.length; ++i) {
            if (liquids[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            liquids[i].writeToNBT(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        nbttagcompound.func_74782_a("PendingLiquids", (NBTBase)nbttaglist);
        NBTTagCompound NBTproductSlot = new NBTTagCompound();
        this.productTank.writeToNBT(NBTproductSlot);
        nbttagcompound.func_74782_a("ProductTank", (NBTBase)NBTproductSlot);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        NBTTagCompound nbttagcompound1;
        int i;
        super.func_70307_a(nbttagcompound);
        this.productionTime = nbttagcompound.func_74762_e("ProductionTime");
        this.timePerItem = nbttagcompound.func_74762_e("TimePerItem");
        this.inventory.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.func_74761_m("PendingRemnants");
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            this.pendingRemnants.add(ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1));
        }
        nbttaglist = nbttagcompound.func_74761_m("PendingLiquids");
        for (i = 0; i < nbttaglist.func_74745_c(); ++i) {
            nbttagcompound1 = (NBTTagCompound)nbttaglist.func_74743_b(i);
            this.pendingLiquids.add(FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbttagcompound1));
        }
        this.productTank = new ForestryTank(10000);
        if (nbttagcompound.func_74764_b("ProductTank")) {
            this.productTank.readFromNBT(nbttagcompound.func_74775_l("ProductTank"));
        }
        this.checkRecipe();
    }

    @Override
    public void updateServerSide() {
        FluidContainerRegistry.FluidContainerData container;
        if (this.inventory.func_70301_a(10) != null && (container = LiquidHelper.getEmptyContainer(this.inventory.func_70301_a(10), this.productTank.getFluid())) != null) {
            this.inventory.func_70299_a(11, this.bottleIntoContainer(this.inventory.func_70301_a(10), this.inventory.func_70301_a(11), container, this.productTank));
            if (this.inventory.func_70301_a((int)10).field_77994_a <= 0) {
                this.inventory.func_70299_a(10, null);
            }
        }
        if (this.field_70331_k.func_82737_E() % 20L * 10L != 0L) {
            return;
        }
        this.checkRecipe();
        if (this.getErrorState() == EnumErrorCode.NORECIPE && this.currentRecipe != null) {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    @Override
    public boolean workCycle() {
        this.checkRecipe();
        this.tryAddPending();
        if (!this.pendingLiquids.isEmpty() || !this.pendingRemnants.isEmpty()) {
            return false;
        }
        if (this.productionTime <= 0) {
            return false;
        }
        if (this.currentRecipe == null) {
            return false;
        }
        --this.productionTime;
        if (this.productionTime > 0) {
            this.setErrorState(EnumErrorCode.OK);
            return true;
        }
        this.pendingLiquids.push(this.currentRecipe.liquid.copy());
        if (this.currentRecipe.remnants != null && this.field_70331_k.field_73012_v.nextInt(100) < this.currentRecipe.chance) {
            this.pendingRemnants.push(this.currentRecipe.remnants.func_77946_l());
        }
        this.removeResources(this.currentRecipe.resources);
        this.checkRecipe();
        this.resetRecipe();
        this.tryAddPending();
        this.setErrorState(EnumErrorCode.OK);
        return true;
    }

    private void checkRecipe() {
        Recipe sameRec = RecipeManager.findMatchingRecipe(this.inventory.getStacks(0, 9));
        if (sameRec == null) {
            this.setErrorState(EnumErrorCode.NORECIPE);
        }
        if (this.currentRecipe != sameRec) {
            this.currentRecipe = sameRec;
            this.resetRecipe();
        }
    }

    private void resetRecipe() {
        if (this.currentRecipe == null) {
            this.productionTime = 0;
            this.timePerItem = 0;
            return;
        }
        this.productionTime = this.currentRecipe.timePerItem;
        this.timePerItem = this.currentRecipe.timePerItem;
    }

    private boolean tryAddPending() {
        FluidStack next;
        if (!this.pendingLiquids.isEmpty() && this.addProduct(next = (FluidStack)this.pendingLiquids.peek())) {
            this.pendingLiquids.pop();
            return true;
        }
        if (!this.pendingRemnants.isEmpty() && this.addRemnant((ItemStack)(next = (ItemStack)this.pendingRemnants.peek()))) {
            this.pendingRemnants.pop();
            return true;
        }
        if (!this.pendingLiquids.isEmpty() || !this.pendingRemnants.isEmpty()) {
            this.setErrorState(EnumErrorCode.NOSPACE);
        }
        return false;
    }

    private boolean addProduct(FluidStack stack) {
        stack.amount -= this.productTank.fill(stack, true);
        return stack.amount <= 0;
    }

    private boolean addRemnant(ItemStack stack) {
        return this.inventory.tryAddStack(stack, 9, 1, true);
    }

    private void removeResources(ItemStack[] stacks) {
        this.inventory.removeResources(stacks, 0, 9);
    }

    @Override
    public boolean isWorking() {
        return this.currentRecipe != null && this.productTank.getFluidAmount() < this.productTank.getCapacity();
    }

    @Override
    public boolean hasWork() {
        return this.currentRecipe != null && this.productTank.getFluidAmount() < this.productTank.getCapacity();
    }

    public int getProgressScaled(int i) {
        if (this.timePerItem == 0) {
            return i;
        }
        return this.productionTime * i / this.timePerItem;
    }

    public int getResourceScaled(int i) {
        return this.productTank.getFluidAmount() * i / 10000;
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.productionTime = j;
                break;
            }
            case 1: {
                this.timePerItem = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.productionTime);
        iCrafting.func_71112_a(container, 1, this.timePerItem);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public InventoryAdapter getInternalInventory() {
        return this.inventory;
    }

    @Override
    protected boolean canTakeStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canTakeStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        return slotIndex == 9 || slotIndex == 11;
    }

    @Override
    protected boolean canPutStackFromSide(int slotIndex, ItemStack itemstack, int side) {
        if (!super.canPutStackFromSide(slotIndex, itemstack, side)) {
            return false;
        }
        if (slotIndex == 10) {
            return LiquidHelper.isEmptyContainer(itemstack);
        }
        if (slotIndex >= 0 && slotIndex < 9) {
            return !LiquidHelper.isEmptyContainer(itemstack);
        }
        return false;
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        if (LiquidHelper.isEmptyContainer(stack)) {
            return this.inventory.addStack(stack, 10, 1, false, doAdd);
        }
        return this.inventory.addStack(stack, 0, 9, false, doAdd);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.inventory.func_70301_a(11) != null) {
            ItemStack product = new ItemStack(this.inventory.func_70301_a((int)11).field_77993_c, 1, this.inventory.func_70301_a(11).func_77960_j());
            if (doRemove) {
                this.inventory.func_70298_a(11, 1);
            }
            return new ItemStack[]{product};
        }
        if (this.inventory.func_70301_a(9) == null) {
            return StackUtils.EMPTY_STACK_ARRAY;
        }
        ItemStack product = new ItemStack(this.inventory.func_70301_a((int)9).field_77993_c, 1, this.inventory.func_70301_a(9).func_77960_j());
        if (doRemove) {
            this.inventory.func_70298_a(9, 1);
        }
        return new ItemStack[]{product};
    }

    @Override
    public FluidStack drain(ForgeDirection from, int quantityMax, boolean doEmpty) {
        return this.productTank.drain(quantityMax, doEmpty);
    }

    @Override
    public ForestryTank[] getTanks() {
        return new ForestryTank[]{this.productTank};
    }

    @Override
    public LinkedList getCustomTriggers() {
        LinkedList<Trigger> res = new LinkedList<Trigger>();
        res.add(ForestryTrigger.hasWork);
        return res;
    }

    public static class RecipeManager
    implements ISqueezerManager {
        public static ArrayList recipes = new ArrayList();

        @Override
        public void addRecipe(int timePerItem, ItemStack[] resources, FluidStack liquid, ItemStack remnants, int chance) {
            recipes.add(new Recipe(timePerItem, resources, liquid, remnants, chance));
        }

        @Override
        public void addRecipe(int timePerItem, ItemStack[] resources, FluidStack liquid) {
            this.addRecipe(timePerItem, resources, liquid, null, 0);
        }

        public static Recipe findMatchingRecipe(ItemStack[] items) {
            for (int i = 0; i < recipes.size(); ++i) {
                Recipe recipe = (Recipe)recipes.get(i);
                if (!recipe.matches(items)) continue;
                return recipe;
            }
            return null;
        }

        @Override
        public Map getRecipes() {
            HashMap<ItemStack[], Object[]> recipeList = new HashMap<ItemStack[], Object[]>();
            for (Recipe recipe : recipes) {
                recipeList.put(recipe.resources, new Object[]{recipe.remnants, recipe.liquid});
            }
            return recipeList;
        }
    }

    public static class Recipe {
        public final int timePerItem;
        public final ItemStack[] resources;
        public final FluidStack liquid;
        public final ItemStack remnants;
        public final int chance;

        public Recipe(int timePerItem, ItemStack[] resources, FluidStack liquid, ItemStack remnants, int chance) {
            this.timePerItem = timePerItem;
            this.resources = resources;
            this.liquid = liquid;
            this.remnants = remnants;
            this.chance = chance;
        }

        public boolean matches(ItemStack[] res) {
            if (res == null || res.length <= 0) {
                return false;
            }
            boolean matchedAll = true;
            for (ItemStack stack : this.resources) {
                boolean matched = false;
                for (ItemStack matchStack : res) {
                    if (matchStack == null || !matchStack.func_77969_a(stack) || matchStack.field_77994_a < stack.field_77994_a) continue;
                    matched = true;
                    break;
                }
                if (matched) continue;
                matchedAll = false;
            }
            return matchedAll;
        }
    }
}

