/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.gadgets;

import buildcraft.api.inventory.ISpecialInventory;
import forestry.api.core.ForestryAPI;
import forestry.api.fuels.GeneratorFuel;
import forestry.core.EnumErrorCode;
import forestry.core.config.Config;
import forestry.core.gadgets.TileBase;
import forestry.core.interfaces.ILiquidTankContainer;
import forestry.core.interfaces.IRenderableMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.proxy.Proxies;
import forestry.core.utils.EnumTankLevel;
import forestry.core.utils.ForestryTank;
import forestry.core.utils.InventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StackUtils;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Utils;
import forestry.plugins.PluginIC2;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySource;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class MachineGenerator
extends TileBase
implements ISpecialInventory,
ILiquidTankContainer,
IEnergySource,
IRenderableMachine {
    public static final short SLOT_CAN = 0;
    @EntityNetData
    public ForestryTank resourceTank = new ForestryTank(10000);
    public int energyStored;
    public int energyMax;
    public boolean isAddedToEnergyNet;
    private int tickCount = 0;
    InventoryAdapter inventory = new InventoryAdapter(1, "Items");

    public MachineGenerator() {
        this.setHints((String[])Config.hints.get("generator"));
        this.energyMax = 30000;
    }

    @Override
    public String func_70303_b() {
        return StringUtil.localize("engine.3");
    }

    @Override
    public void openGui(EntityPlayer player, TileBase tile) {
        player.openGui(ForestryAPI.instance, GuiId.GeneratorGUI.ordinal(), player.field_70170_p, this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74768_a("EnergyStored", this.energyStored);
        nbttagcompound.func_74768_a("EnergyMax", this.energyMax);
        NBTTagCompound NBTresourceSlot = new NBTTagCompound();
        this.resourceTank.writeToNBT(NBTresourceSlot);
        nbttagcompound.func_74782_a("ResourceTank", (NBTBase)NBTresourceSlot);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.energyStored = nbttagcompound.func_74762_e("EnergyStored");
        this.energyMax = nbttagcompound.func_74762_e("EnergyMax");
        this.resourceTank = new ForestryTank(10000);
        if (nbttagcompound.func_74764_b("ResourceTank")) {
            this.resourceTank.readFromNBT(nbttagcompound.func_74775_l("ResourceTank"));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    public void onChunkUnload() {
        this.onUnload();
        super.onChunkUnload();
    }

    public void func_70313_j() {
        this.onUnload();
        super.func_70313_j();
    }

    @Override
    public void updateServerSide() {
        FluidContainerRegistry.FluidContainerData container;
        if (this.inventory.func_70301_a(0) != null && (container = LiquidHelper.getLiquidContainer(this.inventory.func_70301_a(0))) != null && GeneratorFuel.fuels.containsKey(container.fluid.fluidID)) {
            this.inventory.func_70299_a(0, StackUtils.replenishByContainer(this, this.inventory.func_70301_a(0), container, this.resourceTank));
            if (this.inventory.func_70301_a((int)0).field_77994_a <= 0) {
                this.inventory.func_70299_a(0, null);
            }
        }
        if (!PluginIC2.instance.isAvailable()) {
            this.setErrorState(EnumErrorCode.NOENERGYNET);
            return;
        }
        if (!this.isAddedToEnergyNet) {
            this.onLoad();
        }
        if (this.resourceTank.getFluidAmount() > 0 && this.energyStored <= this.energyMax - 10) {
            if (GeneratorFuel.fuels.containsKey(this.resourceTank.getFluid().fluidID)) {
                GeneratorFuel fuel = (GeneratorFuel)GeneratorFuel.fuels.get(this.resourceTank.getFluid().fluidID);
                ++this.tickCount;
                this.energyStored += fuel.eu;
                if (this.tickCount >= fuel.rate) {
                    this.tickCount = 0;
                    this.resourceTank.drain(fuel.fuelConsumed.amount, true);
                }
            }
        } else if (this.energyStored > 0) {
            int emit;
            if (this.energyStored >= 32) {
                emit = 32;
                this.energyStored -= 32;
            } else {
                emit = this.energyStored;
                this.energyStored = 0;
            }
            this.energyStored += emit;
        }
        if (this.resourceTank.getFluidAmount() <= 0) {
            this.setErrorState(EnumErrorCode.NOFUEL);
        } else {
            this.setErrorState(EnumErrorCode.OK);
        }
    }

    public boolean isWorking() {
        return this.resourceTank.getFluidAmount() > 0;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.getFluidAmount() * i / 10000;
    }

    public int getStoredScaled(int i) {
        return this.energyStored * i / this.energyMax;
    }

    @Override
    public EnumTankLevel getPrimaryLevel() {
        return Utils.rateTankLevel(this.getResourceScaled(100));
    }

    @Override
    public EnumTankLevel getSecondaryLevel() {
        return EnumTankLevel.EMPTY;
    }

    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.energyStored = j;
                break;
            }
            case 1: {
                this.energyMax = j;
            }
        }
    }

    public void sendGUINetworkData(Container container, ICrafting iCrafting) {
        iCrafting.func_71112_a(container, 0, this.energyStored);
        iCrafting.func_71112_a(container, 1, this.energyMax);
    }

    public ItemStack func_70301_a(int i) {
        return this.inventory.func_70301_a(i);
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        this.inventory.func_70299_a(i, itemstack);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70298_a(int i, int j) {
        return this.inventory.func_70298_a(i, j);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        FluidContainerRegistry.FluidContainerData container = LiquidHelper.getLiquidContainer(stack);
        if (container == null) {
            return 0;
        }
        if (!GeneratorFuel.fuels.containsKey(container.fluid.fluidID)) {
            return 0;
        }
        if (this.inventory.func_70301_a(0) == null) {
            if (doAdd) {
                this.inventory.func_70299_a(0, stack.func_77946_l());
            }
            return stack.field_77994_a;
        }
        if (!this.inventory.func_70301_a(0).func_77969_a(stack)) {
            return 0;
        }
        int space = this.inventory.func_70301_a(0).func_77976_d() - this.inventory.func_70301_a((int)0).field_77994_a;
        if (space <= 0) {
            return 0;
        }
        if (doAdd) {
            this.inventory.func_70301_a((int)0).field_77994_a += stack.field_77994_a;
        }
        return Math.min(space, stack.field_77994_a);
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        return null;
    }

    @Override
    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (!GeneratorFuel.fuels.containsKey(resource.fluidID)) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.sendNetworkUpdate();
        }
        return used;
    }

    @Override
    public ForestryTank[] getTanks() {
        return new ForestryTank[]{this.resourceTank};
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return true;
    }

    @Override
    public double getOfferedEnergy() {
        return Math.min(this.energyStored, 32);
    }

    @Override
    public void drawEnergy(double amount) {
        this.energyStored = (int)((double)this.energyStored - ((double)this.energyStored >= amount ? amount : (double)this.energyStored));
    }

    private void onLoad() {
        if (Proxies.common.isSimulating(this.field_70331_k) && PluginIC2.instance.isAvailable()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.isAddedToEnergyNet = true;
        }
    }

    private void onUnload() {
        if (Proxies.common.isSimulating(this.field_70331_k) && PluginIC2.instance.isAvailable() && this.isAddedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.isAddedToEnergyNet = false;
        }
    }
}

