/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils;

import cpw.mods.fml.common.registry.LanguageRegistry;
import forestry.api.recipes.RecipeManagers;
import forestry.core.config.ForestryItem;
import forestry.core.render.TextureManager;
import forestry.core.utils.Localization;
import forestry.core.utils.StackUtils;
import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;

public class LiquidHelper {
    private static LinkedList myLiquids = new LinkedList();
    private static HashMap liquidMap = new HashMap();

    public static boolean isEmptyLiquidData() {
        return FluidContainerRegistry.getRegisteredFluidContainerData().length <= 0;
    }

    public static boolean isEmptyContainer(ItemStack empty) {
        return FluidContainerRegistry.isEmptyContainer((ItemStack)empty);
    }

    public static FluidContainerRegistry.FluidContainerData getEmptyContainer(ItemStack empty, FluidStack liquid) {
        for (FluidContainerRegistry.FluidContainerData cont : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!cont.fluid.isFluidEqual(liquid) || cont.emptyContainer == null || !cont.emptyContainer.func_77969_a(empty)) continue;
            return cont;
        }
        return null;
    }

    public static FluidContainerRegistry.FluidContainerData getLiquidContainer(ItemStack container) {
        for (FluidContainerRegistry.FluidContainerData cont : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!cont.filledContainer.func_77969_a(container)) continue;
            return cont;
        }
        return null;
    }

    public static FluidContainerRegistry.FluidContainerData createLiquidData(String ident, FluidStack stillLiquid, ItemStack filled, ItemStack container) {
        return new FluidContainerRegistry.FluidContainerData(new FluidStack(LiquidHelper.getOrCreateLiquid(ident), 1000), filled, container);
    }

    public static boolean isLiquid(String ident, FluidStack stack) {
        return FluidRegistry.getFluidID((String)ident) == stack.fluidID;
    }

    public static boolean exists(String ident) {
        return FluidRegistry.isFluidRegistered((String)ident);
    }

    public static Fluid getFluid(String ident) {
        Fluid fluid = FluidRegistry.getFluid((String)ident);
        return fluid;
    }

    public static Fluid getOrCreateLiquid(String ident) {
        if (!FluidRegistry.isFluidRegistered((String)ident)) {
            Fluid fluid = new Fluid(ident);
            LanguageRegistry.instance().addStringLocalization(fluid.getUnlocalizedName(), Localization.instance.get(fluid.getUnlocalizedName()));
            FluidRegistry.registerFluid((Fluid)fluid);
            myLiquids.add(ident);
        }
        liquidMap.put(ident, FluidRegistry.getFluid((String)ident));
        return FluidRegistry.getFluid((String)ident);
    }

    public static FluidStack getLiquid(String name, int amount) {
        return FluidRegistry.getFluidStack((String)name, (int)amount);
    }

    public static void injectLiquidContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, null, 0);
    }

    public static void injectWaxContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, ForestryItem.beeswax.getItemStack(), 10);
    }

    public static void injectRefractoryContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, ForestryItem.refractoryWax.getItemStack(), 10);
    }

    public static void injectTinContainer(String name, int volume, ItemStack filled, ItemStack empty) {
        LiquidHelper.injectLiquidContainer(name, volume, filled, empty, ForestryItem.ingotTin.getItemStack(), 5);
    }

    public static void injectLiquidContainer(String name, int volume, ItemStack filled, ItemStack empty, ItemStack remnant, int chance) {
        FluidStack contained = LiquidHelper.getLiquid(name, volume);
        if (contained == null) {
            throw new IllegalArgumentException(String.format("Attempted to inject a liquid container for the non-existent liquid '%s'.", name));
        }
        FluidContainerRegistry.FluidContainerData container = new FluidContainerRegistry.FluidContainerData(contained, filled, empty);
        FluidContainerRegistry.registerFluidContainer((FluidContainerRegistry.FluidContainerData)container);
        if (RecipeManagers.squeezerManager != null && !container.filledContainer.func_77973_b().func_77634_r()) {
            if (remnant != null) {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{container.filledContainer}, container.fluid, remnant, chance);
            } else {
                RecipeManagers.squeezerManager.addRecipe(10, new ItemStack[]{container.filledContainer}, container.fluid);
            }
        }
    }

    public static void resetLiquidIcons(IconRegister register) {
        for (String fluidString : myLiquids) {
            Fluid fluid = LiquidHelper.getFluid(fluidString);
            Icon icon = TextureManager.getInstance().registerTex(register, "liquid/" + fluid.getName());
            fluid.setIcons(icon);
        }
    }

    public static boolean handleRightClick(IFluidHandler tank, ForgeDirection side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            FluidStack available;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            if (fill && liquid != null) {
                int used = tank.fill(side, liquid, true);
                if (used > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, StackUtils.consumeItem(current));
                    }
                    return true;
                }
            } else if (drain && (available = tank.drain(side, Integer.MAX_VALUE, false)) != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                if (current.field_77994_a > 1) {
                    if (!player.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, StackUtils.consumeItem(current));
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, StackUtils.consumeItem(current));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                }
                tank.drain(side, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public static void processContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean processFilled, boolean processEmpty) {
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input == null) {
            return;
        }
        if (processFilled && LiquidHelper.drainContainers(fluidHandler, inv, inputSlot, outputSlot)) {
            return;
        }
        if (processEmpty && fluidToFill != null) {
            LiquidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill);
        }
    }

    public static boolean fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        return LiquidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill, true);
    }

    public static boolean fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean doFill) {
        FluidStack fluidInContainer;
        FluidStack drain;
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        ItemStack filled = LiquidHelper.getFilledContainer(fluidToFill, input);
        if (filled != null && (output == null || output.field_77994_a < output.func_77976_d() && StackUtils.isIdenticalItem(filled, output)) && (drain = fluidHandler.drain(ForgeDirection.UNKNOWN, fluidInContainer = LiquidHelper.getFluidStackInContainer(filled), false)) != null && drain.amount == fluidInContainer.amount) {
            if (doFill) {
                fluidHandler.drain(ForgeDirection.UNKNOWN, fluidInContainer, true);
                if (output == null) {
                    inv.func_70299_a(outputSlot, filled);
                } else {
                    ++output.field_77994_a;
                }
                inv.func_70298_a(inputSlot, 1);
            }
            return true;
        }
        return false;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot) {
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        if (input != null) {
            int used;
            FluidStack fluidInContainer = LiquidHelper.getFluidStackInContainer(input);
            ItemStack emptyItem = input.func_77973_b().getContainerItemStack(input);
            if (fluidInContainer != null && (emptyItem == null || output == null || output.field_77994_a < output.func_77976_d() && StackUtils.isIdenticalItem(output, emptyItem)) && (used = fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, false)) >= fluidInContainer.amount) {
                fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, true);
                if (emptyItem != null) {
                    if (output == null) {
                        inv.func_70299_a(outputSlot, emptyItem);
                    } else {
                        ++output.field_77994_a;
                    }
                }
                inv.func_70298_a(inputSlot, 1);
                return true;
            }
        }
        return false;
    }

    public static ItemStack getFilledContainer(Fluid fluid, ItemStack empty) {
        if (fluid == null || empty == null) {
            return null;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)new FluidStack(fluid, Integer.MAX_VALUE), (ItemStack)empty);
    }

    public static FluidStack getFluidStackInContainer(ItemStack stack) {
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
    }

    public static boolean containsFluidStack(ItemStack stack, FluidStack fluidStack) {
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)fluidStack);
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)new FluidStack(fluid, 1));
    }
}

