/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.slots;

import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class SlotForestry
extends Slot
implements IToolTipProvider {
    protected boolean isPhantom;
    protected boolean isInfinite;
    protected boolean canAdjustPhantom = true;
    protected boolean canShift = true;
    protected int stackLimit;
    private ToolTip toolTips;

    public SlotForestry(IInventory inventory, int slotIndex, int xPos, int yPos) {
        this(inventory, slotIndex, xPos, yPos, -1);
    }

    public SlotForestry(IInventory inventory, int slotIndex, int xPos, int yPos, int stackLimit) {
        super(inventory, slotIndex, xPos, yPos);
        this.stackLimit = stackLimit;
    }

    public SlotForestry setInfinite() {
        this.isInfinite = true;
        return this;
    }

    public SlotForestry setPhantom() {
        this.isPhantom = true;
        return this;
    }

    public SlotForestry blockShift() {
        this.canShift = false;
        return this;
    }

    public SlotForestry setCanAdjustPhantom(boolean canAdjust) {
        this.canAdjustPhantom = canAdjust;
        return this;
    }

    public SlotForestry setCanShift(boolean canShift) {
        this.canShift = canShift;
        return this;
    }

    public SlotForestry setStackLimit(int limit) {
        this.stackLimit = limit;
        return this;
    }

    public boolean isPhantom() {
        return this.isPhantom;
    }

    public boolean canAdjustPhantom() {
        return this.canAdjustPhantom;
    }

    public boolean func_82869_a(EntityPlayer stack) {
        return !this.isPhantom();
    }

    public boolean canShift() {
        return this.canShift;
    }

    public int func_75219_a() {
        if (this.stackLimit < 0) {
            return super.func_75219_a();
        }
        return this.stackLimit;
    }

    public ItemStack func_75209_a(int i) {
        if (!this.isInfinite) {
            return super.func_75209_a(i);
        }
        ItemStack stack = this.field_75224_c.func_70301_a(this.getSlotIndex());
        if (stack == null) {
            return null;
        }
        ItemStack result = stack.func_77946_l();
        result.field_77994_a = i;
        return result;
    }

    public void onSlotClick(int slotIndex, int button, int modifier, EntityPlayer player) {
    }

    public void setToolTips(ToolTip toolTips) {
        this.toolTips = toolTips;
    }

    @Override
    public ToolTip getToolTip() {
        return this.toolTips;
    }

    @Override
    public boolean isToolTipVisible() {
        return this.func_75211_c() == null;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        return mouseX >= this.field_75223_e && mouseX <= this.field_75223_e + 16 && mouseY >= this.field_75221_f && mouseY <= this.field_75221_f + 16;
    }
}

