/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.gadgets;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IFruitBearer;
import forestry.api.genetics.IFruitFamily;
import forestry.core.network.ForestryPacket;
import forestry.core.network.INetworkedEntity;
import forestry.core.network.PacketPayload;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import forestry.core.render.TextureManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.packet.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Icon;

public class TileFruitPod
extends TileEntity
implements INetworkedEntity,
IFruitBearer {
    private static final short MAX_MATURITY = 2;
    private IAlleleFruit allele;
    private short maturity;
    private int[] indices = new int[0];
    private float sappiness;

    public void setFruit(IAlleleFruit allele, float sappiness, short[] indices) {
        this.allele = allele;
        this.sappiness = sappiness;
        this.indices = new int[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            this.indices[i] = indices[i];
        }
    }

    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        IAllele stored = AlleleManager.alleleRegistry.getAllele(nbttagcompound.func_74779_i("UID"));
        this.allele = stored != null && stored instanceof IAlleleFruit ? (IAlleleFruit)stored : (IAlleleFruit)AlleleManager.alleleRegistry.getAllele("fruitCocoa");
        this.maturity = nbttagcompound.func_74765_d("MT");
        this.sappiness = nbttagcompound.func_74760_g("SP");
        this.indices = nbttagcompound.func_74759_k("IN");
    }

    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        if (this.allele != null) {
            nbttagcompound.func_74778_a("UID", this.allele.getUID());
        }
        nbttagcompound.func_74777_a("MT", this.maturity);
        nbttagcompound.func_74776_a("SP", this.sappiness);
        nbttagcompound.func_74783_a("IN", this.indices);
    }

    public boolean canUpdate() {
        return false;
    }

    public void onBlockTick() {
        if (this.canMature() && this.field_70331_k.field_73012_v.nextFloat() <= this.sappiness) {
            this.mature();
        }
    }

    public void mature() {
        this.maturity = (short)(this.maturity + 1);
        this.sendNetworkUpdateRipening();
    }

    public boolean canMature() {
        return this.maturity < 2;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getBlockTexture(int metadata, int side) {
        if (this.maturity < this.indices.length) {
            return TextureManager.getInstance().getIcon((short)this.indices[this.maturity]);
        }
        return null;
    }

    public short getMaturity() {
        return this.maturity;
    }

    public ItemStack[] getDrop() {
        return this.allele.getProvider().getFruits(null, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.maturity);
    }

    public Packet func_70319_e() {
        return this.toPacket().getPacket();
    }

    @Override
    public void sendNetworkUpdate() {
        Proxies.net.sendNetworkPacket(this.toPacket(), this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private void sendNetworkUpdateRipening() {
        Proxies.net.sendNetworkPacket(new PacketUpdate(1, this.field_70329_l, this.field_70330_m, this.field_70327_n, this.maturity), this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    private ForestryPacket toPacket() {
        PacketPayload payload = new PacketPayload(this.indices.length, 1);
        payload.shortPayload[0] = this.maturity;
        payload.intPayload = this.indices;
        return new PacketUpdate(1, this.field_70329_l, this.field_70330_m, this.field_70327_n, payload);
    }

    @Override
    public void fromPacket(ForestryPacket packetRaw) {
        PacketUpdate packet = (PacketUpdate)packetRaw;
        this.maturity = packet.payload.shortPayload[0];
        if (packet.payload.intPayload != null && packet.payload.intPayload.length > 0) {
            this.indices = packet.payload.intPayload;
        }
        this.field_70331_k.func_72902_n(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    @Override
    public boolean hasFruit() {
        return true;
    }

    @Override
    public IFruitFamily getFruitFamily() {
        if (this.allele == null) {
            return null;
        }
        return this.allele.getProvider().getFamily();
    }

    @Override
    public Collection pickFruit(ItemStack tool) {
        if (this.allele == null) {
            return new ArrayList();
        }
        List<ItemStack> fruits = Arrays.asList(this.getDrop());
        this.maturity = 0;
        this.sendNetworkUpdateRipening();
        return fruits;
    }

    @Override
    public float getRipeness() {
        return (float)this.maturity / 2.0f;
    }

    @Override
    public void addRipeness(float add) {
        this.maturity = (short)((float)this.maturity + 2.0f * add);
        this.sendNetworkUpdateRipening();
    }
}

