/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import forestry.api.arboriculture.ITreeGenome;
import forestry.api.genetics.IFruitFamily;
import forestry.arboriculture.FruitProviderNone;
import forestry.plugins.PluginArboriculture;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FruitProviderRandom
extends FruitProviderNone {
    HashMap products = new HashMap();
    int colour = 0xFFFFFF;

    public FruitProviderRandom(String key, IFruitFamily family, ItemStack product, float modifier) {
        super(key, family);
        this.products.put(product, Float.valueOf(modifier));
    }

    public FruitProviderRandom setColour(int colour) {
        this.colour = colour;
        return this;
    }

    @Override
    public int getColour(ITreeGenome genome, IBlockAccess world, int x, int y, int z, int ripeningTime) {
        return this.colour;
    }

    @Override
    public ItemStack[] getFruits(ITreeGenome genome, World world, int x, int y, int z, int ripeningTime) {
        ArrayList<ItemStack> product = new ArrayList<ItemStack>();
        float modeYieldMod = PluginArboriculture.treeInterface.getTreekeepingMode(world).getYieldModifier(genome, 1.0f);
        for (Map.Entry entry : this.products.entrySet()) {
            if (!(world.field_73012_v.nextFloat() <= genome.getYield() * modeYieldMod * ((Float)entry.getValue()).floatValue())) continue;
            product.add(((ItemStack)entry.getKey()).func_77946_l());
        }
        return product.toArray(new ItemStack[0]);
    }

    @Override
    public ItemStack[] getProducts() {
        return this.products.keySet().toArray(new ItemStack[0]);
    }

    @Override
    public ItemStack[] getSpecialty() {
        return new ItemStack[0];
    }

    @Override
    public boolean markAsFruitLeaf(ITreeGenome genome, World world, int x, int y, int z) {
        return true;
    }
}

