/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.render;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.registry.TickRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class ParticleRenderer
implements ITickHandler {
    private static final String name = "forestry-particles";
    private static ParticleRenderer instance = null;
    private boolean lazyAdd = false;
    private final List particles = new ArrayList();
    private final List newParticles = new ArrayList();

    public static synchronized ParticleRenderer getInstance() {
        if (instance == null) {
            instance = new ParticleRenderer();
        }
        return instance;
    }

    public synchronized void addEffect(EntityFX particle) {
        if (this.lazyAdd) {
            this.newParticles.add(particle);
        } else {
            this.particles.add(particle);
        }
    }

    @ForgeSubscribe
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        this.render(event.partialTicks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ForgeSubscribe
    public void onWorldUnload(WorldEvent.Unload event) {
        if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            ParticleRenderer particleRenderer = this;
            synchronized (particleRenderer) {
                this.particles.clear();
            }
        }
    }

    public void tickStart(EnumSet type, Object ... tickData) {
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
        this.update();
    }

    public EnumSet ticks() {
        return EnumSet.of(TickType.CLIENT);
    }

    public String getLabel() {
        return name;
    }

    private ParticleRenderer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        TickRegistry.registerTickHandler((ITickHandler)this, (Side)Side.CLIENT);
    }

    private synchronized void update() {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("forestry-particles-update");
        this.lazyAdd = true;
        Iterator it = this.particles.iterator();
        while (it.hasNext()) {
            EntityFX particle = (EntityFX)it.next();
            particle.func_70071_h_();
            if (!particle.field_70128_L) continue;
            it.remove();
        }
        this.lazyAdd = false;
        this.particles.addAll(this.newParticles);
        this.newParticles.clear();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }

    private synchronized void render(float partialTicks) {
        Minecraft.func_71410_x().field_71424_I.func_76320_a("forestry-particles-render");
        float rotationX = ActiveRenderInfo.field_74588_d;
        float rotationZ = ActiveRenderInfo.field_74586_f;
        float rotationYZ = ActiveRenderInfo.field_74587_g;
        float rotationXY = ActiveRenderInfo.field_74596_h;
        float rotationXZ = ActiveRenderInfo.field_74589_e;
        EntityLivingBase player = Minecraft.func_71410_x().field_71451_h;
        EntityFX.field_70556_an = player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTicks;
        EntityFX.field_70554_ao = player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTicks;
        EntityFX.field_70555_ap = player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTicks;
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        GL11.glPushAttrib((int)16640);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glAlphaFunc((int)516, (float)0.003921569f);
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        for (EntityFX particle : this.particles) {
            tessellator.func_78380_c(particle.func_70070_b(partialTicks));
            particle.func_70539_a(tessellator, partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
        }
        tessellator.func_78381_a();
        GL11.glPopAttrib();
        Minecraft.func_71410_x().field_71424_I.func_76319_b();
    }
}

