/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.summa.worldgen;

import extrabiomes.lib.Element;
import extrabiomes.module.summa.TreeSoilRegistry;
import extrabiomes.module.summa.worldgen.WorldGenNewTreeBase;
import java.util.Random;

public class WorldGenCypressTree
extends WorldGenNewTreeBase {
    private static long lastSeed = 1234L;
    private static final int BASE_HEIGHT = 12;
    private static final int BASE_HEIGHT_VARIANCE = 6;
    private static final int CANOPY_START_HEIGHT = 0;
    private static final int CANOPY_START_VARIANCE = 4;
    private static final double CANOPY_RADIUS = 1.5;
    private static final double CANOPY_RADIUS_VARIANCE = 1.0;

    public WorldGenCypressTree(boolean par1) {
        super(par1);
    }

    public boolean a(abw world, Random rand, int x, int y, int z2) {
        lastSeed = rand.nextLong();
        if (!this.checkTree(world, new Random(lastSeed), x, y, z2)) {
            return false;
        }
        return this.generateTree(world, new Random(lastSeed), x, y, z2);
    }

    public boolean generate(abw world, long seed, int x, int y, int z2) {
        lastSeed = seed;
        if (!this.checkTree(world, new Random(lastSeed), x, y, z2)) {
            return false;
        }
        return this.generateTree(world, new Random(seed), x, y, z2);
    }

    private boolean checkTree(abw world, Random rand, int x, int y, int z2) {
        int below = world.a(x, y - 1, z2);
        int height = rand.nextInt(6) + 12;
        int start = 0 + (int)(rand.nextDouble() * 4.0 - 2.0);
        double radius = 1.5 + (rand.nextDouble() * 1.0 + 0.5);
        double factor = 16.0 / (double)(2 + height - start);
        int chunkCheck = (int)Math.ceil(radius) + 1;
        if (!TreeSoilRegistry.isValidSoil(below) || y >= 256 - height - 4) {
            return false;
        }
        if (y < 1 || y + height + 4 > 256) {
            return false;
        }
        if (!world.e(x - chunkCheck, y - chunkCheck, z2 - chunkCheck, x + chunkCheck, y + chunkCheck, z2 + chunkCheck)) {
            return false;
        }
        if (!this.check1x1Trunk(x, y, z2, height, TreeBlock.TRUNK.get(), world)) {
            return false;
        }
        for (int layer = 0; layer < 4 + height - start; ++layer) {
            double offset = factor * (double)layer;
            double offset2 = offset * offset;
            double offset3 = offset2 * offset;
            double r1 = radius * (0.00142 * offset3 - 0.0517 * offset2 + 0.5085 * offset - 0.4611);
            if (this.checkLeavesCircle(x, layer + start + y, z2, r1, world)) continue;
            return false;
        }
        return true;
    }

    private boolean generateTree(abw world, Random rand, int x, int y, int z2) {
        int below = world.a(x, y - 1, z2);
        int height = rand.nextInt(6) + 12;
        int start = 0 + (int)(rand.nextDouble() * 4.0 - 2.0);
        double radius = 1.5 + (rand.nextDouble() * 1.0 + 0.5);
        double factor = 16.0 / (double)(2 + height - start);
        int chunkCheck = (int)Math.ceil(radius) + 1;
        if (!TreeSoilRegistry.isValidSoil(below) || y >= 256 - height - 4) {
            return false;
        }
        if (y < 1 || y + height + 4 > 256) {
            return false;
        }
        if (!world.e(x - chunkCheck, y - chunkCheck, z2 - chunkCheck, x + chunkCheck, y + chunkCheck, z2 + chunkCheck)) {
            return false;
        }
        if (this.place1x1Trunk(x, y, z2, height, TreeBlock.TRUNK.get(), world)) {
            for (int layer = 0; layer < 4 + height - start; ++layer) {
                double offset = factor * (double)layer;
                double offset2 = offset * offset;
                double offset3 = offset2 * offset;
                double r1 = radius * (0.00142 * offset3 - 0.0517 * offset2 + 0.5085 * offset - 0.4611);
                this.placeLeavesCircle(x, layer + start + y, z2, r1, TreeBlock.LEAVES.get(), world);
            }
            return true;
        }
        return false;
    }

    public static long getLastSeed() {
        return lastSeed;
    }

    private static enum TreeBlock {
        LEAVES(new ye((aqz)aqz.P, 1, 1)),
        TRUNK(new ye(aqz.O, 1, 1));

        private ye stack;
        private static boolean loadedCustomBlocks;

        private static void loadCustomBlocks() {
            if (Element.LEAVES_CYPRESS.isPresent()) {
                TreeBlock.LEAVES.stack = Element.LEAVES_CYPRESS.get();
            }
            if (Element.LOG_CYPRESS.isPresent()) {
                TreeBlock.TRUNK.stack = Element.LOG_CYPRESS.get();
            }
            loadedCustomBlocks = true;
        }

        private TreeBlock(ye stack) {
            this.stack = stack;
        }

        public ye get() {
            if (!loadedCustomBlocks) {
                TreeBlock.loadCustomBlocks();
            }
            return this.stack;
        }

        static {
            loadedCustomBlocks = false;
        }
    }
}

