/*
 * Decompiled with CFR 0.152.
 */
package extrabiomes.module.fabrica.block;

import com.google.common.base.Optional;
import extrabiomes.Extrabiomes;
import extrabiomes.api.Stuff;
import extrabiomes.events.BlockActiveEvent;
import extrabiomes.lib.BlockSettings;
import extrabiomes.lib.Element;
import extrabiomes.module.amica.buildcraft.FacadeHelper;
import extrabiomes.module.fabrica.block.BlockCustomStairs;
import extrabiomes.module.fabrica.block.BlockCustomWall;
import extrabiomes.module.fabrica.block.BlockCustomWood;
import extrabiomes.module.fabrica.block.BlockCustomWoodSlab;
import extrabiomes.module.fabrica.block.BlockNewWoodSlab;
import extrabiomes.module.fabrica.block.BlockRedRockSlab;
import extrabiomes.module.fabrica.block.BlockWoodStairs;
import extrabiomes.module.fabrica.block.FuelHandlerWoodSlabs;
import extrabiomes.module.fabrica.block.ItemNewWoodSlab;
import extrabiomes.module.fabrica.block.ItemRedRockSlab;
import extrabiomes.module.fabrica.block.ItemWoodSlab;
import extrabiomes.proxy.CommonProxy;
import extrabiomes.utility.MultiItemBlock;

public enum BlockManager {
    PLANKS{

        @Override
        protected void create() {
            Stuff.planks = Optional.of((Object)((Object)new BlockCustomWood(this.getSettings().getID())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.PLANKS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.planks.get();
            thisBlock.c("extrabiomes.planks");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, MultiItemBlock.class, thisBlock.a() + ":" + thisBlock.getClass().getName());
            for (BlockCustomWood.BlockType type : BlockCustomWood.BlockType.values()) {
                FacadeHelper.addBuildcraftFacade(thisBlock.cF, type.metadata());
            }
            proxy.registerOreInAllSubblocks("plankWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.PlankActiveEvent(thisBlock));
        }
    }
    ,
    NEWWOODSLAB{

        @Override
        protected void create() {
            Stuff.newslabWood = Optional.of((Object)((Object)new BlockNewWoodSlab(this.getSettings().getID(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.NEWWOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.newslabWood.get();
            thisBlock.c("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerFuelHandler(new FuelHandlerWoodSlabs(thisBlock.cF));
            Extrabiomes.postInitEvent(new BlockActiveEvent.NewWoodSlabActiveEvent(thisBlock));
        }
    }
    ,
    NEWDOUBLEWOODSLAB{

        @Override
        protected void create() {
            Stuff.newslabWoodDouble = Optional.of((Object)((Object)new BlockNewWoodSlab(this.getSettings().getID(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.NEWDOUBLEWOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.newslabWoodDouble.get();
            thisBlock.c("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            ItemNewWoodSlab.setSlabs((aop)Stuff.newslabWood.get(), (aop)Stuff.newslabWoodDouble.get());
            proxy.registerBlock((aqz)Stuff.newslabWood.get(), ItemNewWoodSlab.class, ((aqz)Stuff.newslabWood.get()).a() + ":" + ((aqz)Stuff.newslabWood.get()).getClass().getName());
            proxy.registerBlock(thisBlock, ItemNewWoodSlab.class, thisBlock.a() + ":double:" + thisBlock.getClass().getName());
            proxy.registerOreInAllSubblocks("slabWood", (aqz)Stuff.newslabWood.get());
        }
    }
    ,
    WOODSLAB{

        @Override
        protected void create() {
            Stuff.slabWood = Optional.of((Object)((Object)new BlockCustomWoodSlab(this.getSettings().getID(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.slabWood.get();
            thisBlock.c("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerFuelHandler(new FuelHandlerWoodSlabs(thisBlock.cF));
            Extrabiomes.postInitEvent(new BlockActiveEvent.WoodSlabActiveEvent(thisBlock));
        }
    }
    ,
    DOUBLEWOODSLAB{

        @Override
        protected void create() {
            Stuff.slabWoodDouble = Optional.of((Object)((Object)new BlockCustomWoodSlab(this.getSettings().getID(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.DOUBLEWOODSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.slabWoodDouble.get();
            thisBlock.c("extrabiomes.woodslab");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            ItemWoodSlab.setSlabs((aop)Stuff.slabWood.get(), (aop)Stuff.slabWoodDouble.get());
            proxy.registerBlock((aqz)Stuff.slabWood.get(), ItemWoodSlab.class, ((aqz)Stuff.slabWood.get()).a() + ":" + ((aqz)Stuff.slabWood.get()).getClass().getName());
            proxy.registerBlock(thisBlock, ItemWoodSlab.class, thisBlock.a() + ":double:" + thisBlock.getClass().getName());
            proxy.registerOreInAllSubblocks("slabWood", (aqz)Stuff.slabWood.get());
        }
    }
    ,
    REDWOODSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedwood = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (aqz)Stuff.planks.get(), BlockCustomWood.BlockType.REDWOOD.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDWOODSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsRedwood.get();
            thisBlock.c("extrabiomes.stairs.redwood");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedwoodStairsActiveEvent(thisBlock));
        }
    }
    ,
    FIRSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsFir = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (aqz)Stuff.planks.get(), BlockCustomWood.BlockType.FIR.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.FIRSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsFir.get();
            thisBlock.c("extrabiomes.stairs.fir");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.FirStairsActiveEvent(thisBlock));
        }
    }
    ,
    ACACIASTAIRS{

        @Override
        protected void create() {
            Stuff.stairsAcacia = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (aqz)Stuff.planks.get(), BlockCustomWood.BlockType.ACACIA.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.ACACIASTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsAcacia.get();
            thisBlock.c("extrabiomes.stairs.acacia");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.AcaciaStairsActiveEvent(thisBlock));
        }
    }
    ,
    RAINBOWEUCALYPTUSSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRainbowEucalyptus = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (aqz)Stuff.planks.get(), BlockCustomWood.BlockType.RAINBOW_EUCALYPTUS.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.RAINBOWEUCALYPTUSSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsRainbowEucalyptus.get();
            thisBlock.c("extrabiomes.stairs.rainboweucalyptus");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RainbowEucalyptusStairsActiveEvent(thisBlock));
        }
    }
    ,
    CYPRESSSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsCypress = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (aqz)Stuff.planks.get(), BlockCustomWood.BlockType.CYPRESS.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.CYPRESSSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsCypress.get();
            thisBlock.c("extrabiomes.stairs.cypress");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.CypressStairsActiveEvent(thisBlock));
        }
    }
    ,
    BALDCYPRESSSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsBaldCypress = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (aqz)Stuff.planks.get(), BlockCustomWood.BlockType.BALD_CYPRESS.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.BALDCYPRESSSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsBaldCypress.get();
            thisBlock.c("extrabiomes.stairs.baldcypress");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.BaldCypressStairsActiveEvent(thisBlock));
        }
    }
    ,
    JAPANESEMAPLESTAIRS{

        @Override
        protected void create() {
            Stuff.stairsJapaneseMaple = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (aqz)Stuff.planks.get(), BlockCustomWood.BlockType.JAPANESE_MAPLE.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.JAPANESEMAPLESTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsJapaneseMaple.get();
            thisBlock.c("extrabiomes.stairs.japanesemaple");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.JapaneseMapleStairsActiveEvent(thisBlock));
        }
    }
    ,
    AUTUMNSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsAutumn = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (aqz)Stuff.planks.get(), BlockCustomWood.BlockType.AUTUMN.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.AUTUMNSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsAutumn.get();
            thisBlock.c("extrabiomes.stairs.autumn");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.AutumnStairsActiveEvent(thisBlock));
        }
    }
    ,
    SAKURABLOSSOMSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsSakuraBlossom = Optional.of((Object)((Object)new BlockWoodStairs(this.getSettings().getID(), (aqz)Stuff.planks.get(), BlockCustomWood.BlockType.SAKURA_BLOSSOM.metadata())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.SAKURABLOSSOMSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsSakuraBlossom.get();
            thisBlock.c("extrabiomes.stairs.sakurablossom");
            proxy.setBlockHarvestLevel(thisBlock, "axe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            proxy.registerOre("stairWood", thisBlock);
            Extrabiomes.postInitEvent(new BlockActiveEvent.SakuraBlossomStairsActiveEvent(thisBlock));
        }
    }
    ,
    REDROCKSLAB{

        @Override
        protected void create() {
            Stuff.slabRedRock = Optional.of((Object)((Object)new BlockRedRockSlab(this.getSettings().getID(), false)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDROCKSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.slabRedRock.get();
            thisBlock.c("extrabiomes.redrockslab");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockSlabActiveEvent(thisBlock));
        }
    }
    ,
    DOUBLEREDROCKSLAB{

        @Override
        protected void create() {
            Stuff.slabRedRockDouble = Optional.of((Object)((Object)new BlockRedRockSlab(this.getSettings().getID(), true)));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.DOUBLEREDROCKSLAB;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.slabRedRockDouble.get();
            thisBlock.c("extrabiomes.redrockslab");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            ItemRedRockSlab.setSlabs((aop)Stuff.slabRedRock.get(), (aop)Stuff.slabRedRockDouble.get());
            proxy.registerBlock((aqz)Stuff.slabRedRock.get(), ItemRedRockSlab.class, ((aqz)Stuff.slabRedRock.get()).a() + ":" + ((aqz)Stuff.slabRedRock.get()).getClass().getName());
            proxy.registerBlock(thisBlock, ItemRedRockSlab.class, thisBlock.a() + ":double:" + thisBlock.getClass().getName());
        }
    }
    ,
    REDCOBBLESTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedCobble = Optional.of((Object)((Object)new BlockCustomStairs(this.getSettings().getID(), aqz.s[Element.RED_COBBLE.get().d], Element.RED_COBBLE.get().k())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDCOBBLESTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsRedCobble.get();
            thisBlock.c("extrabiomes.stairs.redcobble");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedCobbleStairsActiveEvent(thisBlock));
        }
    }
    ,
    REDROCKBRICKSTAIRS{

        @Override
        protected void create() {
            Stuff.stairsRedRockBrick = Optional.of((Object)((Object)new BlockCustomStairs(this.getSettings().getID(), aqz.s[Element.RED_ROCK_BRICK.get().d], Element.RED_ROCK_BRICK.get().k())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.REDROCKBRICKSTAIRS;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.stairsRedRockBrick.get();
            thisBlock.c("extrabiomes.stairs.redrockbrick");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock, thisBlock.a() + ":" + thisBlock.getClass().getName());
            Extrabiomes.postInitEvent(new BlockActiveEvent.RedRockBrickStairsActiveEvent(thisBlock));
        }
    }
    ,
    WALL{

        @Override
        protected void create() {
            Stuff.wall = Optional.of((Object)((Object)new BlockCustomWall(this.getSettings().getID())));
        }

        @Override
        protected BlockSettings getSettings() {
            return BlockSettings.WALL;
        }

        @Override
        protected void prepare() {
            CommonProxy proxy = Extrabiomes.proxy;
            aqz thisBlock = (aqz)Stuff.wall.get();
            thisBlock.c("extrabiomes.wall");
            proxy.setBlockHarvestLevel(thisBlock, "pickaxe", 0);
            proxy.registerBlock(thisBlock, MultiItemBlock.class, thisBlock.a() + ":" + thisBlock.getClass().getName());
            Extrabiomes.postInitEvent(new BlockActiveEvent.WallActiveEvent(thisBlock));
        }
    };

    private boolean blockCreated = false;

    private static void createBlocks() throws Exception {
        for (BlockManager block : BlockManager.values()) {
            if (block.getSettings().getID() <= 0) continue;
            block.create();
            block.blockCreated = true;
        }
    }

    public static void init() throws InstantiationException, IllegalAccessException {
        for (BlockManager block : BlockManager.values()) {
            if (!block.blockCreated) continue;
            block.prepare();
        }
    }

    public static void preInit() throws Exception {
        BlockManager.createBlocks();
    }

    protected abstract void create();

    protected abstract BlockSettings getSettings();

    protected abstract void prepare();
}

