/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator;

import bspkrs.treecapitator.TCSettings;
import bspkrs.util.BlockID;
import bspkrs.util.HashCodeUtil;
import bspkrs.util.ListUtils;
import java.util.ArrayList;
import java.util.List;

public class TreeDefinition {
    protected List<BlockID> logBlocks = new ArrayList<BlockID>();
    protected List<BlockID> leafBlocks = new ArrayList<BlockID>();
    protected boolean allowSmartTreeDetection = TCSettings.allowSmartTreeDetection;
    protected boolean onlyDestroyUpwards = TCSettings.onlyDestroyUpwards;
    protected boolean requireLeafDecayCheck = TCSettings.requireLeafDecayCheck;
    protected int maxHorLogBreakDist = TCSettings.maxHorLogBreakDist;
    protected int maxVerLogBreakDist = TCSettings.maxVerLogBreakDist;
    protected int maxLeafIDDist = TCSettings.maxLeafIDDist;
    protected int maxHorLeafBreakDist = TCSettings.maxHorLeafBreakDist;
    protected int minLeavesToID = TCSettings.minLeavesToID;
    protected float breakSpeedModifier = TCSettings.breakSpeedModifier;
    protected boolean useAdvancedTopLogLogic = TCSettings.useAdvancedTopLogLogic;

    public TreeDefinition() {
    }

    public TreeDefinition(List<BlockID> logs, List<BlockID> leaves) {
        this();
        this.logBlocks.addAll(logs);
        this.leafBlocks.addAll(leaves);
    }

    public TreeDefinition(by tree) {
        this();
        this.readFromNBT(tree);
    }

    public boolean equals(Object o) {
        if (!(o instanceof TreeDefinition)) {
            return false;
        }
        if (o == this) {
            return true;
        }
        TreeDefinition td = (TreeDefinition)o;
        return td.logBlocks.equals(this.logBlocks) && td.leafBlocks.equals(this.leafBlocks);
    }

    public int hashCode() {
        int result = 23;
        result = HashCodeUtil.hash((int)result, this.logBlocks);
        result = HashCodeUtil.hash((int)result, this.leafBlocks);
        return result;
    }

    public boolean isLogBlock(BlockID blockID) {
        return this.logBlocks.contains(blockID);
    }

    public boolean isLeafBlock(BlockID blockID) {
        return this.leafBlocks.contains(blockID);
    }

    public TreeDefinition addLogID(BlockID blockID) {
        if (!this.isLogBlock(blockID)) {
            this.logBlocks.add(blockID);
        }
        return this;
    }

    public TreeDefinition addLeafID(BlockID blockID) {
        if (!this.isLeafBlock(blockID)) {
            this.leafBlocks.add(blockID);
        }
        return this;
    }

    public TreeDefinition append(TreeDefinition toAdd) {
        for (BlockID blockID : toAdd.logBlocks) {
            if (this.logBlocks.contains(blockID)) continue;
            this.logBlocks.add(blockID);
        }
        for (BlockID blockID : toAdd.leafBlocks) {
            if (this.leafBlocks.contains(blockID)) continue;
            this.leafBlocks.add(blockID);
        }
        return this;
    }

    public TreeDefinition appendWithSettings(TreeDefinition toAdd) {
        this.append(toAdd);
        if (toAdd.allowSmartTreeDetection != TCSettings.allowSmartTreeDetection) {
            this.allowSmartTreeDetection = toAdd.allowSmartTreeDetection;
        }
        if (toAdd.onlyDestroyUpwards != TCSettings.onlyDestroyUpwards) {
            this.onlyDestroyUpwards = toAdd.onlyDestroyUpwards;
        }
        if (toAdd.requireLeafDecayCheck != TCSettings.requireLeafDecayCheck) {
            this.requireLeafDecayCheck = toAdd.requireLeafDecayCheck;
        }
        if (toAdd.maxHorLogBreakDist != TCSettings.maxHorLogBreakDist) {
            this.maxHorLogBreakDist = toAdd.maxHorLogBreakDist;
        }
        if (toAdd.maxHorLeafBreakDist != TCSettings.maxHorLeafBreakDist) {
            this.maxHorLeafBreakDist = toAdd.maxHorLeafBreakDist;
        }
        if (toAdd.maxLeafIDDist != TCSettings.maxLeafIDDist) {
            this.maxLeafIDDist = toAdd.maxLeafIDDist;
        }
        if (toAdd.minLeavesToID != TCSettings.minLeavesToID) {
            this.minLeavesToID = toAdd.minLeavesToID;
        }
        if (toAdd.breakSpeedModifier != TCSettings.breakSpeedModifier) {
            this.breakSpeedModifier = toAdd.breakSpeedModifier;
        }
        if (toAdd.useAdvancedTopLogLogic != TCSettings.useAdvancedTopLogLogic) {
            this.useAdvancedTopLogLogic = toAdd.useAdvancedTopLogLogic;
        }
        return this;
    }

    public TreeDefinition readFromNBT(by treeDefNBT) {
        if (treeDefNBT.b("allowSmartTreeDetection")) {
            this.allowSmartTreeDetection = treeDefNBT.n("allowSmartTreeDetection");
        }
        if (treeDefNBT.b("onlyDestroyUpwards")) {
            this.onlyDestroyUpwards = treeDefNBT.n("onlyDestroyUpwards");
        }
        if (treeDefNBT.b("requireLeafDecayCheck")) {
            this.requireLeafDecayCheck = treeDefNBT.n("requireLeafDecayCheck");
        }
        if (treeDefNBT.b("maxHorLogBreakDist")) {
            this.maxHorLogBreakDist = treeDefNBT.e("maxHorLogBreakDist");
        }
        if (treeDefNBT.b("maxVerLogBreakDist")) {
            this.maxVerLogBreakDist = treeDefNBT.e("maxVerLogBreakDist");
        }
        if (treeDefNBT.b("maxHorLeafBreakDist")) {
            this.maxHorLeafBreakDist = treeDefNBT.e("maxHorLeafBreakDist");
        }
        if (treeDefNBT.b("maxLeafIDDist")) {
            this.maxLeafIDDist = treeDefNBT.e("maxLeafIDDist");
        }
        if (treeDefNBT.b("minLeavesToID")) {
            this.minLeavesToID = treeDefNBT.e("minLeavesToID");
        }
        if (treeDefNBT.b("breakSpeedModifier")) {
            this.breakSpeedModifier = treeDefNBT.g("breakSpeedModifier");
        }
        if (treeDefNBT.b("useAdvancedTopLogLogic")) {
            this.useAdvancedTopLogLogic = treeDefNBT.n("useAdvancedTopLogLogic");
        }
        this.logBlocks = treeDefNBT.b("logs") && treeDefNBT.i("logs").length() > 0 ? ListUtils.getDelimitedStringAsBlockIDList((String)treeDefNBT.i("logs"), (String)";") : new ArrayList<BlockID>();
        this.leafBlocks = treeDefNBT.b("leaves") && treeDefNBT.i("leaves").length() > 0 ? ListUtils.getDelimitedStringAsBlockIDList((String)treeDefNBT.i("leaves"), (String)";") : new ArrayList<BlockID>();
        return this;
    }

    public void writeToNBT(by treeDefNBT) {
        treeDefNBT.a("allowSmartTreeDetection", this.allowSmartTreeDetection);
        treeDefNBT.a("onlyDestroyUpwards", this.onlyDestroyUpwards);
        treeDefNBT.a("requireLeafDecayCheck", this.requireLeafDecayCheck);
        treeDefNBT.a("maxHorLogBreakDist", this.maxHorLogBreakDist);
        treeDefNBT.a("maxVerLogBreakDist", this.maxVerLogBreakDist);
        treeDefNBT.a("maxHorLeafBreakDist", this.maxHorLeafBreakDist);
        treeDefNBT.a("maxLeafIDDist", this.maxLeafIDDist);
        treeDefNBT.a("minLeavesToID", this.minLeavesToID);
        treeDefNBT.a("breakSpeedModifier", this.breakSpeedModifier);
        treeDefNBT.a("useAdvancedTopLogLogic", this.useAdvancedTopLogLogic);
        treeDefNBT.a("logs", ListUtils.getListAsDelimitedString(this.logBlocks, (String)";"));
        treeDefNBT.a("leaves", ListUtils.getListAsDelimitedString(this.leafBlocks, (String)";"));
    }

    public TreeDefinition setAllowSmartTreeDetection(boolean allowSmartTreeDetection) {
        this.allowSmartTreeDetection = allowSmartTreeDetection;
        return this;
    }

    public TreeDefinition setOnlyDestroyUpwards(boolean onlyDestroyUpwards) {
        this.onlyDestroyUpwards = onlyDestroyUpwards;
        return this;
    }

    public TreeDefinition setRequireLeafDecayCheck(boolean requireLeafDecayCheck) {
        this.requireLeafDecayCheck = requireLeafDecayCheck;
        return this;
    }

    public TreeDefinition setMaxHorLogBreakDist(int maxHorLogBreakDist) {
        this.maxHorLogBreakDist = maxHorLogBreakDist;
        return this;
    }

    public TreeDefinition setMaxVerLogBreakDist(int maxVerLogBreakDist) {
        this.maxVerLogBreakDist = maxVerLogBreakDist;
        return this;
    }

    public TreeDefinition setMaxLeafIDDist(int maxLeafIDDist) {
        this.maxLeafIDDist = maxLeafIDDist;
        return this;
    }

    public TreeDefinition setMaxHorLeafBreakDist(int maxLeafBreakDist) {
        this.maxHorLeafBreakDist = maxLeafBreakDist;
        return this;
    }

    public TreeDefinition setMinLeavesToID(int minLeavesToID) {
        this.minLeavesToID = minLeavesToID;
        return this;
    }

    public TreeDefinition setBreakSpeedModifier(float breakSpeedModifier) {
        this.breakSpeedModifier = breakSpeedModifier;
        return this;
    }

    public TreeDefinition setUseAdvancedTopLogLogic(boolean useAdvancedTopLogLogic) {
        this.useAdvancedTopLogLogic = useAdvancedTopLogLogic;
        return this;
    }

    public List<BlockID> getLogList() {
        return new ArrayList<BlockID>(this.logBlocks);
    }

    public List<BlockID> getLeafList() {
        return new ArrayList<BlockID>(this.leafBlocks);
    }

    public boolean allowSmartTreeDetection() {
        return this.allowSmartTreeDetection;
    }

    public boolean onlyDestroyUpwards() {
        return this.onlyDestroyUpwards;
    }

    public boolean requireLeafDecayCheck() {
        return this.requireLeafDecayCheck;
    }

    public int maxHorLogBreakDist() {
        return this.maxHorLogBreakDist;
    }

    public int maxVerLogBreakDist() {
        return this.maxVerLogBreakDist;
    }

    public int maxLeafIDDist() {
        return this.maxLeafIDDist;
    }

    public int maxHorLeafBreakDist() {
        return this.maxHorLeafBreakDist;
    }

    public int minLeavesToID() {
        return this.minLeavesToID;
    }

    public float breakSpeedModifier() {
        return this.breakSpeedModifier;
    }

    public boolean useAdvancedTopLogLogic() {
        return this.useAdvancedTopLogLogic;
    }
}

