/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item;

import ic2.api.item.ElectricItem;
import ic2.api.item.IElectricItem;
import ic2.api.item.IElectricItemManager;
import ic2.core.IC2;
import ic2.core.util.StackUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ElectricItemManager
implements IElectricItemManager {
    @Override
    public int charge(ItemStack aStack, int aCharge, int tier, boolean ignoreTransferLimit, boolean simulate) {
        IElectricItem item = (IElectricItem)aStack.func_77973_b();
        assert (item.getMaxCharge(aStack) > 0);
        if (aCharge < 0 || aStack.field_77994_a > 1 || item.getTier(aStack) > tier) {
            return 0;
        }
        if (!ignoreTransferLimit && aCharge > item.getTransferLimit(aStack)) {
            aCharge = item.getTransferLimit(aStack);
        }
        NBTTagCompound tNBT = StackUtil.getOrCreateNbtData(aStack);
        int tNewCharge = tNBT.func_74762_e("charge");
        if (aCharge > item.getMaxCharge(aStack) - tNewCharge) {
            aCharge = item.getMaxCharge(aStack) - tNewCharge;
        }
        if (!simulate) {
            if ((tNewCharge += aCharge) > 0) {
                tNBT.func_74768_a("charge", tNewCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_74758_c().isEmpty()) {
                    aStack.func_77982_d(null);
                }
            }
            int n = aStack.field_77993_c = tNewCharge > 0 ? item.getChargedItemId(aStack) : item.getEmptyItemId(aStack);
            if (aStack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)aStack.func_77973_b();
                if (aStack.func_77958_k() > 2) {
                    aStack.func_77964_b((int)(1L + ((long)item.getMaxCharge(aStack) - (long)tNewCharge) * ((long)aStack.func_77958_k() - 2L) / (long)item.getMaxCharge(aStack)));
                } else {
                    aStack.func_77964_b(0);
                }
            } else {
                aStack.func_77964_b(0);
            }
        }
        return aCharge;
    }

    @Override
    public int discharge(ItemStack aStack, int aCharge, int tier, boolean ignoreTransferLimit, boolean simulate) {
        NBTTagCompound tNBT;
        int tNewCharge;
        IElectricItem item = (IElectricItem)aStack.func_77973_b();
        assert (item.getMaxCharge(aStack) > 0);
        if (aCharge < 0 || aStack.field_77994_a > 1 || item.getTier(aStack) > tier) {
            return 0;
        }
        if (!ignoreTransferLimit && aCharge > item.getTransferLimit(aStack)) {
            aCharge = item.getTransferLimit(aStack);
        }
        if (aCharge > (tNewCharge = (tNBT = StackUtil.getOrCreateNbtData(aStack)).func_74762_e("charge"))) {
            aCharge = tNewCharge;
        }
        if (!simulate) {
            if ((tNewCharge -= aCharge) > 0) {
                tNBT.func_74768_a("charge", tNewCharge);
            } else {
                tNBT.func_82580_o("charge");
                if (tNBT.func_74758_c().isEmpty()) {
                    aStack.func_77982_d(null);
                }
            }
            int n = aStack.field_77993_c = tNewCharge > 0 ? item.getChargedItemId(aStack) : item.getEmptyItemId(aStack);
            if (aStack.func_77973_b() instanceof IElectricItem) {
                item = (IElectricItem)aStack.func_77973_b();
                if (aStack.func_77958_k() > 2) {
                    aStack.func_77964_b((int)(1L + ((long)item.getMaxCharge(aStack) - (long)tNewCharge) * ((long)aStack.func_77958_k() - 2L) / (long)item.getMaxCharge(aStack)));
                } else {
                    aStack.func_77964_b(0);
                }
            } else {
                aStack.func_77964_b(0);
            }
        }
        return aCharge;
    }

    @Override
    public int getCharge(ItemStack itemStack) {
        return ElectricItem.manager.discharge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
    }

    @Override
    public boolean canUse(ItemStack itemStack, int amount) {
        return ElectricItem.manager.getCharge(itemStack) >= amount;
    }

    @Override
    public boolean use(ItemStack itemStack, int amount, EntityLivingBase entity) {
        if (!IC2.platform.isSimulating()) {
            return false;
        }
        ElectricItem.manager.chargeFromArmor(itemStack, entity);
        int transfer = ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, true);
        if (transfer == amount) {
            ElectricItem.manager.discharge(itemStack, amount, Integer.MAX_VALUE, true, false);
            ElectricItem.manager.chargeFromArmor(itemStack, entity);
            return true;
        }
        return false;
    }

    @Override
    public void chargeFromArmor(ItemStack itemStack, EntityLivingBase entity) {
        if (!IC2.platform.isSimulating()) {
            return;
        }
        boolean inventoryChanged = false;
        for (int i = 0; i < 4; ++i) {
            IElectricItem armorItem;
            ItemStack armorItemStack = entity.func_71124_b(i + 1);
            if (armorItemStack == null || !(armorItemStack.func_77973_b() instanceof IElectricItem) || !(armorItem = (IElectricItem)armorItemStack.func_77973_b()).canProvideEnergy(armorItemStack) || armorItem.getTier(armorItemStack) < ((IElectricItem)itemStack.func_77973_b()).getTier(itemStack)) continue;
            int transfer = ElectricItem.manager.charge(itemStack, Integer.MAX_VALUE, Integer.MAX_VALUE, true, true);
            if ((transfer = ElectricItem.manager.discharge(armorItemStack, transfer, Integer.MAX_VALUE, true, false)) <= 0) continue;
            ElectricItem.manager.charge(itemStack, transfer, Integer.MAX_VALUE, true, false);
            inventoryChanged = true;
        }
        if (inventoryChanged && entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).field_71070_bA.func_75142_b();
        }
    }

    @Override
    public String getToolTip(ItemStack itemStack) {
        IElectricItem item = (IElectricItem)itemStack.func_77973_b();
        return ElectricItem.manager.getCharge(itemStack) + "/" + item.getMaxCharge(itemStack) + " EU";
    }
}

