/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.wiring;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.energy.tile.IEnergySource;
import ic2.api.network.INetworkClientTileEntityEventListener;
import ic2.api.tile.IEnergyStorage;
import ic2.core.ContainerBase;
import ic2.core.IC2;
import ic2.core.IHasGui;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlot;
import ic2.core.block.invslot.InvSlotCharge;
import ic2.core.block.invslot.InvSlotDischarge;
import ic2.core.block.wiring.ContainerElectricBlock;
import ic2.core.block.wiring.GuiElectricBlock;
import ic2.core.util.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TileEntityElectricBlock
extends TileEntityInventory
implements IEnergySink,
IEnergySource,
IHasGui,
INetworkClientTileEntityEventListener,
IEnergyStorage {
    public final int tier;
    public int output;
    public int maxStorage;
    public double energy = 0.0;
    public boolean hasRedstone = false;
    public byte redstoneMode = 0;
    private boolean isMigrated = true;
    public static byte redstoneModes = (byte)6;
    private boolean isEmittingRedstone = false;
    private int redstoneUpdateInhibit = 5;
    public boolean addedToEnergyNet = false;
    public final InvSlotCharge chargeSlot;
    public final InvSlotDischarge dischargeSlot;

    public TileEntityElectricBlock(int tier1, int output1, int maxStorage1) {
        this.tier = tier1;
        this.output = output1;
        this.maxStorage = maxStorage1;
        this.chargeSlot = new InvSlotCharge(this, 0, tier1);
        this.dischargeSlot = new InvSlotDischarge(this, 1, tier1, InvSlot.InvSide.BOTTOM);
    }

    public float getChargeLevel() {
        float ret = (float)this.energy / (float)this.maxStorage;
        if (ret > 1.0f) {
            ret = 1.0f;
        }
        return ret;
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        block2: {
            super.func_70307_a(nbttagcompound);
            this.setActiveWithoutNotify(nbttagcompound.func_74767_n("active"));
            try {
                this.energy = nbttagcompound.func_74769_h("energy");
            }
            catch (Exception e) {
                this.energy = nbttagcompound.func_74762_e("energy");
                if (this.maxStorage <= Integer.MAX_VALUE) break block2;
                this.energy *= 10.0;
            }
        }
        this.redstoneMode = nbttagcompound.func_74771_c("redstoneMode");
        this.isMigrated = nbttagcompound.func_74767_n("isMigrated");
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
        nbttagcompound.func_74757_a("active", this.getActive());
        nbttagcompound.func_74774_a("redstoneMode", this.redstoneMode);
        nbttagcompound.func_74757_a("isMigrated", true);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            int meta = this.field_70331_k.func_72805_g(this.field_70329_l, this.field_70330_m, this.field_70327_n);
            if (!(this.isMigrated || meta != 1 && meta != 2)) {
                int newMeta = meta == 1 ? 7 : 1;
                this.field_70328_o = true;
                this.field_70331_k.func_72921_c(this.field_70329_l, this.field_70330_m, this.field_70327_n, newMeta, 2);
                TileEntityElectricBlock newTe = (TileEntityElectricBlock)this.field_70331_k.func_72796_p(this.field_70329_l, this.field_70330_m, this.field_70327_n);
                newTe.energy = this.energy;
                newTe.redstoneMode = this.redstoneMode;
                newTe.setActiveWithoutNotify(this.getActive());
                newTe.setFacing(this.getFacing());
                newTe.chargeSlot.put(this.chargeSlot.get());
                newTe.dischargeSlot.put(this.dischargeSlot.get());
            } else {
                MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
                this.addedToEnergyNet = true;
            }
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        boolean shouldEmitRedstone;
        super.func_70316_g();
        boolean needsInvUpdate = false;
        if (this.energy >= 1.0) {
            int sent = this.chargeSlot.charge((int)this.energy);
            this.energy -= (double)sent;
            boolean bl = needsInvUpdate = sent > 0;
        }
        if (this.demandedEnergyUnits() > 0.0) {
            int gain = this.dischargeSlot.discharge((int)((double)this.maxStorage - this.energy), false);
            this.energy += (double)gain;
            boolean bl = needsInvUpdate = gain > 0;
        }
        if (this.redstoneMode == 4 || this.redstoneMode == 5) {
            this.hasRedstone = this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        if ((shouldEmitRedstone = this.shouldEmitRedstone()) != this.isEmittingRedstone) {
            this.isEmittingRedstone = shouldEmitRedstone;
            this.setActive(this.isEmittingRedstone);
            this.field_70331_k.func_72898_h(this.field_70329_l, this.field_70330_m, this.field_70327_n, this.field_70331_k.func_72798_a(this.field_70329_l, this.field_70330_m, this.field_70327_n));
        }
        if (needsInvUpdate) {
            this.func_70296_d();
        }
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return !this.facingMatchesDirection(direction);
    }

    @Override
    public boolean emitsEnergyTo(TileEntity receiver, ForgeDirection direction) {
        return this.facingMatchesDirection(direction);
    }

    public boolean facingMatchesDirection(ForgeDirection direction) {
        return direction.ordinal() == this.getFacing();
    }

    @Override
    public double getOfferedEnergy() {
        if (!(!(this.energy >= (double)this.output) || this.redstoneMode == 4 && this.hasRedstone || this.redstoneMode == 5 && this.hasRedstone && !(this.energy >= (double)this.maxStorage))) {
            return this.output;
        }
        return 0.0;
    }

    @Override
    public void drawEnergy(double amount) {
        this.energy -= amount;
    }

    @Override
    public double demandedEnergyUnits() {
        return (double)this.maxStorage - this.energy;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (this.energy >= (double)this.maxStorage) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public int getMaxSafeInput() {
        return this.output;
    }

    @Override
    public ContainerBase getGuiContainer(EntityPlayer entityPlayer) {
        return new ContainerElectricBlock(entityPlayer, this);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiScreen getGui(EntityPlayer entityPlayer, boolean isAdmin) {
        return new GuiElectricBlock(new ContainerElectricBlock(entityPlayer, this));
    }

    @Override
    public void onGuiClosed(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean wrenchCanSetFacing(EntityPlayer entityPlayer, int side) {
        return this.getFacing() != side;
    }

    @Override
    public void setFacing(short facing) {
        if (this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
        }
        super.setFacing(facing);
        if (this.addedToEnergyNet) {
            this.addedToEnergyNet = false;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    public boolean isEmittingRedstone() {
        return this.isEmittingRedstone;
    }

    public boolean shouldEmitRedstone() {
        boolean shouldEmitRedstone = false;
        switch (this.redstoneMode) {
            case 1: {
                shouldEmitRedstone = this.energy >= (double)(this.maxStorage - this.output * 20);
                break;
            }
            case 2: {
                shouldEmitRedstone = this.energy > (double)this.output && this.energy < (double)this.maxStorage;
                break;
            }
            case 3: {
                boolean bl = shouldEmitRedstone = this.energy < (double)this.output;
            }
        }
        if (this.isEmittingRedstone == shouldEmitRedstone || this.redstoneUpdateInhibit == 0) {
            this.redstoneUpdateInhibit = 5;
            return shouldEmitRedstone;
        }
        --this.redstoneUpdateInhibit;
        return this.isEmittingRedstone;
    }

    @Override
    public void onNetworkEvent(EntityPlayer player, int event) {
        this.redstoneMode = (byte)(this.redstoneMode + 1);
        if (this.redstoneMode >= redstoneModes) {
            this.redstoneMode = 0;
        }
        IC2.platform.messagePlayer(player, this.getredstoneMode(), new Object[0]);
    }

    public String getredstoneMode() {
        if (this.redstoneMode > 5 || this.redstoneMode < 0) {
            return "";
        }
        return StatCollector.func_74838_a((String)("ic2.mausover.eustorage.restonebehavior" + this.redstoneMode));
    }

    @Override
    public ItemStack getWrenchDrop(EntityPlayer entityPlayer) {
        ItemStack ret = super.getWrenchDrop(entityPlayer);
        NBTTagCompound nbttagcompound = StackUtil.getOrCreateNbtData(ret);
        if (IC2.enableEnergyInStorageBlockItems) {
            nbttagcompound.func_74768_a("energy", (int)((long)this.getStored() * (long)IC2.percentualEnergyInStorageBlockItems / 100L));
        }
        return ret;
    }

    @Override
    public int getStored() {
        return (int)this.energy;
    }

    @Override
    public int getCapacity() {
        return this.maxStorage;
    }

    @Override
    public int getOutput() {
        return this.output;
    }

    @Override
    public double getOutputEnergyUnitsPerTick() {
        return this.output;
    }

    @Override
    public void setStored(int energy1) {
        this.energy = energy1;
    }

    @Override
    public int addEnergy(int amount) {
        this.energy += (double)amount;
        return amount;
    }

    @Override
    public boolean isTeleporterCompatible(ForgeDirection side) {
        return true;
    }
}

