/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.block.machine.tileentity;

import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.core.IC2;
import ic2.core.block.TileEntityInventory;
import ic2.core.block.invslot.InvSlotDischarge;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public abstract class TileEntityElectricMachine
extends TileEntityInventory
implements IEnergySink {
    public double energy = 0.0;
    public int maxEnergy;
    private boolean addedToEnergyNet = false;
    private int tier;
    private float guiChargeLevel;
    public final InvSlotDischarge dischargeSlot;

    public TileEntityElectricMachine(int maxenergy, int tier1, int oldDischargeIndex) {
        this.maxEnergy = maxenergy;
        this.tier = tier1;
        this.dischargeSlot = new InvSlotDischarge(this, oldDischargeIndex, tier1);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        try {
            this.energy = nbttagcompound.func_74769_h("energy");
        }
        catch (Exception e) {
            this.energy = nbttagcompound.func_74762_e("energy");
        }
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74780_a("energy", this.energy);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (IC2.platform.isSimulating()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnergyNet = true;
        }
    }

    @Override
    public void onUnloaded() {
        if (IC2.platform.isSimulating() && this.addedToEnergyNet) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnergyNet = false;
        }
        super.onUnloaded();
    }

    @Override
    public boolean enableUpdateEntity() {
        return IC2.platform.isSimulating();
    }

    public void func_70316_g() {
        super.func_70316_g();
        if (IC2.platform.isSimulating()) {
            int amount;
            if ((double)this.maxEnergy - this.energy >= 1.0 && (amount = this.dischargeSlot.discharge((int)((double)this.maxEnergy - this.energy), true)) > 0) {
                this.energy += (double)amount;
                this.func_70296_d();
            }
            this.guiChargeLevel = Math.min(1.0f, (float)this.energy / (float)this.maxEnergy);
        }
    }

    @Override
    public double demandedEnergyUnits() {
        return (double)this.maxEnergy - this.energy;
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        if (this.energy >= (double)this.maxEnergy) {
            return amount;
        }
        this.energy += amount;
        return 0.0;
    }

    @Override
    public int getMaxSafeInput() {
        return EnergyNet.instance.getPowerFromTier(this.tier);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public void onNetworkUpdate(String field) {
        super.onNetworkUpdate(field);
        if (field.equals("tier")) {
            this.setTier(this.tier);
        }
    }

    public final float getChargeLevel() {
        return this.guiChargeLevel;
    }

    public boolean isRedstonePowered() {
        return this.field_70331_k.func_72864_z(this.field_70329_l, this.field_70330_m, this.field_70327_n);
    }

    public void setTier(int tier1) {
        this.tier = tier1;
        this.dischargeSlot.setTier(tier1);
    }
}

