/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Vector3;
import codechicken.multipart.TMultiPart;
import java.util.Random;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.PRColors;
import mrtjp.projectred.core.fx.CoreParticle;
import mrtjp.projectred.core.fx.ParticleLogic;
import mrtjp.projectred.core.fx.ParticleLogicApproachPoint;
import mrtjp.projectred.core.fx.ParticleLogicIconShift;
import mrtjp.projectred.core.fx.ParticleLogicOrbitPoint;
import mrtjp.projectred.core.fx.ParticleLogicScale;
import mrtjp.projectred.core.fx.ParticleLogicTrail;
import mrtjp.projectred.core.fx.ParticleManagement;
import mrtjp.projectred.transportation.BasicPipePart;
import mrtjp.projectred.transportation.RoutedJunctionPipePart;
import mrtjp.projectred.transportation.TransportationSPH;

public class RouteFX {
    private static final Random rand = new Random();
    public static final int color_receive = PRColors.ORANGE.ordinal();
    public static final int color_send = PRColors.PURPLE.ordinal();
    public static final int color_relay = PRColors.CYAN.ordinal();
    public static final int color_routeLost = PRColors.MAGENTA.ordinal();
    public static final int color_route = PRColors.RED.ordinal();
    public static final int color_sync = PRColors.LIGHT_BLUE.ordinal();
    public static final int color_request = PRColors.PINK.ordinal();
    public static final int color_checkInv = PRColors.WHITE.ordinal();
    public static final int color_linked = PRColors.LIME.ordinal();
    public static final int color_unlinked = PRColors.RED.ordinal();
    public static final int color_blink = PRColors.LIGHT_GREY.ordinal();

    public static void spawnType1(int n, int n2, BlockCoord blockCoord, abw abw2) {
        if (!abw2.I) {
            RouteFX.packetType1(n, n2, blockCoord, abw2);
            return;
        }
        PRColors pRColors = PRColors.get((int)n);
        for (int i = 0; i < n2; ++i) {
            RouteFX.doSpawnType1(pRColors, blockCoord, abw2);
        }
    }

    public static void spawnType2(int n, int n2, int n3, BlockCoord blockCoord, abw abw2) {
        if (!abw2.I) {
            RouteFX.packetType2(n, n2, n3, blockCoord, abw2);
            return;
        }
        PRColors pRColors = PRColors.get((int)n);
        for (int i = 0; i < n2; ++i) {
            RouteFX.doSpawnType2(pRColors, n3, blockCoord, abw2);
        }
    }

    public static void spawnType3(int n, int n2, int n3, BlockCoord blockCoord, abw abw2) {
        if (!abw2.I) {
            RouteFX.packetType3(n, n2, n3, blockCoord, abw2);
            return;
        }
        PRColors pRColors = PRColors.get((int)n);
        for (int i = 0; i < n2; ++i) {
            RouteFX.doSpawnType3(pRColors, n3, blockCoord, abw2);
        }
    }

    private static void doSpawnType3(final PRColors pRColors, int n, BlockCoord blockCoord, abw abw2) {
        double d = (double)blockCoord.x + 0.5;
        double d2 = (double)blockCoord.y + 0.5;
        double d3 = (double)blockCoord.z + 0.5;
        CoreParticle coreParticle = ParticleManagement.instance.spawn(abw2, "box", d, d2, d3);
        if (coreParticle != null) {
            ParticleLogicTrail.IParticleBuilder iParticleBuilder = new ParticleLogicTrail.IParticleBuilder(){

                public void build(CoreParticle coreParticle) {
                    ParticleLogicIconShift particleLogicIconShift = ParticleLogicIconShift.fluttering();
                    ParticleLogicScale particleLogicScale = new ParticleLogicScale();
                    particleLogicScale.setRate(-0.001f, -0.001f * rand.nextFloat());
                    particleLogicScale.setTerminate(true);
                    coreParticle.setIgnoreMaxAge(true);
                    coreParticle.setScale(0.05f + 0.02f * rand.nextFloat());
                    coreParticle.setPRColor(pRColors);
                    coreParticle.addLogic((ParticleLogic)particleLogicIconShift).addLogic((ParticleLogic)particleLogicScale);
                }
            };
            ParticleLogicTrail particleLogicTrail = new ParticleLogicTrail("box", iParticleBuilder);
            double d4 = ls.a((Random)rand, (double)0.1, (double)0.2);
            ParticleLogicPipeRouterFlow particleLogicPipeRouterFlow = new ParticleLogicPipeRouterFlow(blockCoord, n, pRColors.ordinal(), d4, 0.1);
            particleLogicPipeRouterFlow.setTerminate(true);
            ParticleLogicScale particleLogicScale = new ParticleLogicScale();
            particleLogicScale.setRate(-1.0E-4f, 0.0f);
            particleLogicScale.setTerminate(true);
            coreParticle.Z = true;
            coreParticle.setIgnoreMaxAge(true);
            coreParticle.setScale(0.05f + 0.075f * rand.nextFloat());
            coreParticle.setPRColor(pRColors);
            coreParticle.addLogic((ParticleLogic)particleLogicTrail).addLogic((ParticleLogic)particleLogicPipeRouterFlow).addLogic((ParticleLogic)particleLogicScale);
        }
    }

    private static void doSpawnType2(final PRColors pRColors, int n, BlockCoord blockCoord, abw abw2) {
        double d = (double)blockCoord.x + 0.5;
        double d2 = (double)blockCoord.y + 0.5;
        double d3 = (double)blockCoord.z + 0.5;
        double d4 = (double)blockCoord.x + 0.5 + ls.a((Random)rand, (double)-0.0625, (double)0.0625);
        double d5 = (double)blockCoord.y + 0.5 + ls.a((Random)rand, (double)-0.0625, (double)0.0625);
        double d6 = (double)blockCoord.z + 0.5 + ls.a((Random)rand, (double)-0.0625, (double)0.0625);
        double d7 = ls.a((Random)rand, (double)0.8, (double)1.0);
        switch (n) {
            case 0: {
                d5 = (double)blockCoord.y + 0.5 - d7;
                break;
            }
            case 1: {
                d5 = (double)blockCoord.y + 0.5 + d7;
                break;
            }
            case 2: {
                d6 = (double)blockCoord.z + 0.5 - d7;
                break;
            }
            case 3: {
                d6 = (double)blockCoord.z + 0.5 + d7;
                break;
            }
            case 4: {
                d4 = (double)blockCoord.x + 0.5 - d7;
                break;
            }
            case 5: {
                d4 = (double)blockCoord.x + 0.5 + d7;
            }
        }
        CoreParticle coreParticle = ParticleManagement.instance.spawn(abw2, "box", d, d2, d3);
        if (coreParticle != null) {
            ParticleLogicTrail.IParticleBuilder iParticleBuilder = new ParticleLogicTrail.IParticleBuilder(){

                public void build(CoreParticle coreParticle) {
                    ParticleLogicIconShift particleLogicIconShift = ParticleLogicIconShift.fluttering();
                    ParticleLogicScale particleLogicScale = new ParticleLogicScale();
                    particleLogicScale.setRate(-0.001f, -0.001f * rand.nextFloat());
                    particleLogicScale.setTerminate(true);
                    coreParticle.setIgnoreMaxAge(true);
                    coreParticle.setScale(0.05f + 0.02f * rand.nextFloat());
                    coreParticle.setPRColor(pRColors);
                    coreParticle.addLogic((ParticleLogic)particleLogicIconShift).addLogic((ParticleLogic)particleLogicScale);
                }
            };
            ParticleLogicTrail particleLogicTrail = new ParticleLogicTrail("box", iParticleBuilder);
            double d8 = ls.a((Random)rand, (double)0.1, (double)0.2);
            ParticleLogicApproachPoint particleLogicApproachPoint = new ParticleLogicApproachPoint(new Vector3(d4, d5, d6), d8, 0.1);
            particleLogicApproachPoint.setTerminate(true);
            ParticleLogicScale particleLogicScale = new ParticleLogicScale();
            particleLogicScale.setRate(-1.0E-4f, -1.0E-4f);
            particleLogicScale.setTerminate(true);
            coreParticle.Z = true;
            coreParticle.setIgnoreMaxAge(true);
            coreParticle.setScale(0.05f + 0.075f * rand.nextFloat());
            coreParticle.setPRColor(pRColors);
            coreParticle.addLogic((ParticleLogic)particleLogicTrail).addLogic((ParticleLogic)particleLogicScale).addLogic((ParticleLogic)particleLogicApproachPoint);
        }
    }

    private static void doSpawnType1(PRColors pRColors, BlockCoord blockCoord, abw abw2) {
        double d = (double)blockCoord.x + 0.5 + ls.a((Random)rand, (double)-0.25, (double)0.25);
        double d2 = (double)blockCoord.y + 0.5 + ls.a((Random)rand, (double)-0.125, (double)0.125);
        double d3 = (double)blockCoord.z + 0.5 + ls.a((Random)rand, (double)-0.25, (double)0.25);
        double d4 = (double)blockCoord.x + 0.5;
        double d5 = (double)blockCoord.y + 0.5 + 1.0;
        double d6 = (double)blockCoord.z + 0.5;
        CoreParticle coreParticle = ParticleManagement.instance.spawn(abw2, "flutter1", d, d2, d3);
        if (coreParticle != null) {
            ParticleLogicOrbitPoint particleLogicOrbitPoint = new ParticleLogicOrbitPoint(new Vector3(d4, d5, d6));
            particleLogicOrbitPoint.setOrbitSpeed(0.5 * rand.nextDouble()).setTargetDistance(0.3);
            particleLogicOrbitPoint.setShrinkingOrbit(0.01, 0.01);
            ParticleLogicScale particleLogicScale = new ParticleLogicScale();
            particleLogicScale.setRate(-0.001f, -1.0E-4f * rand.nextFloat());
            particleLogicScale.setTerminate(true);
            ParticleLogicIconShift particleLogicIconShift = ParticleLogicIconShift.fluttering();
            coreParticle.setIgnoreMaxAge(true);
            coreParticle.setScale(0.05f + 0.02f * rand.nextFloat());
            coreParticle.setPRColor(pRColors);
            coreParticle.addLogic((ParticleLogic)particleLogicOrbitPoint);
            coreParticle.addLogic((ParticleLogic)particleLogicScale);
            coreParticle.addLogic((ParticleLogic)particleLogicIconShift);
        }
    }

    public static void handleClientPacket(MCDataInput mCDataInput, abw abw2) {
        int n = mCDataInput.readUByte();
        int n2 = mCDataInput.readUByte();
        int n3 = mCDataInput.readUByte();
        int n4 = n != 1 ? mCDataInput.readUByte() : -1;
        BlockCoord blockCoord = mCDataInput.readCoord();
        if (n == 1) {
            RouteFX.spawnType1(n2, n3, blockCoord, abw2);
        } else if (n == 2) {
            RouteFX.spawnType2(n2, n3, n4, blockCoord, abw2);
        } else if (n == 3) {
            RouteFX.spawnType3(n2, n3, n4, blockCoord, abw2);
        }
    }

    private static void packetType1(int n, int n2, BlockCoord blockCoord, abw abw2) {
        if (abw2.I) {
            return;
        }
        PacketCustom packetCustom = new PacketCustom((Object)TransportationSPH.channel(), TransportationSPH.particle_Spawn());
        packetCustom.writeByte(1);
        packetCustom.writeByte(n).writeByte(n2).writeCoord(blockCoord);
        packetCustom.sendPacketToAllAround((double)blockCoord.x, (double)blockCoord.y, (double)blockCoord.z, 64.0, abw2.t.i);
    }

    private static void packetType2(int n, int n2, int n3, BlockCoord blockCoord, abw abw2) {
        if (abw2.I) {
            return;
        }
        PacketCustom packetCustom = new PacketCustom((Object)TransportationSPH.channel(), TransportationSPH.particle_Spawn());
        packetCustom.writeByte(2);
        packetCustom.writeByte(n).writeByte(n2).writeCoord(blockCoord).writeByte(n3);
        packetCustom.sendPacketToAllAround((double)blockCoord.x, (double)blockCoord.y, (double)blockCoord.z, 64.0, abw2.t.i);
    }

    private static void packetType3(int n, int n2, int n3, BlockCoord blockCoord, abw abw2) {
        if (abw2.I) {
            return;
        }
        PacketCustom packetCustom = new PacketCustom((Object)TransportationSPH.channel(), TransportationSPH.particle_Spawn());
        packetCustom.writeByte(3);
        packetCustom.writeByte(n).writeByte(n2).writeCoord(blockCoord).writeByte(n3);
        packetCustom.sendPacketToAllAround((double)blockCoord.x, (double)blockCoord.y, (double)blockCoord.z, 64.0, abw2.t.i);
    }

    private static class ParticleLogicPipeRouterFlow
    extends ParticleLogicApproachPoint {
        private int dir;
        private final BlockCoord start;
        private final int color;
        private double deviation = 0.03125;

        public ParticleLogicPipeRouterFlow(BlockCoord blockCoord, int n, int n2, double d, double d2) {
            super(Vector3.zero, d, d2);
            this.dir = n;
            this.start = blockCoord;
            this.color = n2;
            this.setTarget(this.generateNextPoint(blockCoord));
        }

        private Vector3 generateNextPoint(BlockCoord blockCoord) {
            if (blockCoord == null) {
                blockCoord = this.particle.blockPosition();
            }
            double d = (double)blockCoord.x + 0.5 + ls.a((Random)this.rand, (double)(-this.deviation), (double)this.deviation);
            double d2 = (double)blockCoord.y + 0.5 + ls.a((Random)this.rand, (double)(-this.deviation), (double)this.deviation);
            double d3 = (double)blockCoord.z + 0.5 + ls.a((Random)this.rand, (double)(-this.deviation), (double)this.deviation);
            double d4 = ls.a((Random)this.rand, (double)(1.0 - this.deviation), (double)(1.0 + this.deviation));
            switch (this.dir) {
                case 0: {
                    d2 = (double)blockCoord.y + 0.5 - d4;
                    break;
                }
                case 1: {
                    d2 = (double)blockCoord.y + 0.5 + d4;
                    break;
                }
                case 2: {
                    d3 = (double)blockCoord.z + 0.5 - d4;
                    break;
                }
                case 3: {
                    d3 = (double)blockCoord.z + 0.5 + d4;
                    break;
                }
                case 4: {
                    d = (double)blockCoord.x + 0.5 - d4;
                    break;
                }
                case 5: {
                    d = (double)blockCoord.x + 0.5 + d4;
                }
            }
            return new Vector3(d, d2, d3);
        }

        private void setTarget(Vector3 vector3) {
            this.targetX = vector3.x;
            this.targetY = vector3.y;
            this.targetZ = vector3.z;
        }

        public void onDestinationReached() {
            BlockCoord blockCoord = this.particle.blockPosition();
            TMultiPart tMultiPart = BasicUtils.getMultiPart((acf)this.particle.q, (BlockCoord)blockCoord, (int)6);
            if (tMultiPart instanceof BasicPipePart && !(tMultiPart instanceof RoutedJunctionPipePart)) {
                BasicPipePart basicPipePart = (BasicPipePart)tMultiPart;
                int n = basicPipePart.connMap & 0x3F;
                if (Integer.bitCount(n &= ~(1 << (this.dir ^ 1))) == 1) {
                    int n2;
                    for (n2 = 0; (n & 1 << n2) == 0 && n2 < 6; ++n2) {
                    }
                    this.dir = n2;
                    this.setTarget(this.generateNextPoint(blockCoord));
                    return;
                }
                for (int i = 0; i < 6; ++i) {
                    if ((n & 1 << i) == 0) continue;
                    RouteFX.spawnType2(this.color, 1, i, blockCoord, this.particle.q);
                }
                this.finishLogic();
                return;
            }
            this.finishLogic();
        }

        public ParticleLogic clone() {
            ParticleLogicPipeRouterFlow particleLogicPipeRouterFlow = new ParticleLogicPipeRouterFlow(this.start, this.dir, this.color, this.approachSpeed, this.targetDistance);
            particleLogicPipeRouterFlow.setTarget(new Vector3(this.targetX, this.targetY, this.targetZ));
            return particleLogicPipeRouterFlow;
        }
    }
}

