/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.render;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftTransport;
import buildcraft.api.transport.IPipe;
import buildcraft.core.render.RenderEntityBlock;
import buildcraft.core.utils.EnumColor;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.PipeRenderState;
import buildcraft.transport.PipeTransportFluids;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.PipeTransportPower;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TravelingItem;
import com.google.common.collect.Maps;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class PipeRendererTESR
extends TileEntitySpecialRenderer {
    private static final int LIQUID_STAGES = 40;
    private static final int MAX_ITEMS_TO_RENDER = 10;
    private final EntityItem dummyEntityItem = new EntityItem(null);
    private final RenderItem customRenderItem;
    private final HashMap<Integer, DisplayFluidList> displayFluidLists = Maps.newHashMap();
    private final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private static final int POWER_STAGES = 100;
    public int[] displayPowerList = new int[100];
    public int[] displayPowerListOverload = new int[100];
    boolean initialized = false;

    public PipeRendererTESR() {
        this.customRenderItem = new RenderItem(){

            public boolean shouldBob() {
                return false;
            }

            public boolean shouldSpreadItems() {
                return false;
            }
        };
        this.customRenderItem.func_76976_a(RenderManager.field_78727_a);
    }

    private DisplayFluidList getDisplayFluidLists(int liquidId, World world) {
        if (this.displayFluidLists.containsKey(liquidId)) {
            return this.displayFluidLists.get(liquidId);
        }
        DisplayFluidList d = new DisplayFluidList();
        this.displayFluidLists.put(liquidId, d);
        RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
        Fluid fluid = FluidRegistry.getFluid((int)liquidId);
        block.baseBlock = fluid.getBlockID() > 0 ? Block.field_71973_m[fluid.getBlockID()] : Block.field_71943_B;
        block.texture = fluid.getStillIcon();
        float size = 0.5f;
        for (int s = 0; s < 40; ++s) {
            float ratio = (float)s / 40.0f;
            d.sideHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.sideVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.sideVertical[s], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerHorizontal[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
            d.centerVertical[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)d.centerVertical[s], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        return d;
    }

    private void initializeDisplayPowerList(World world) {
        float unit;
        float minSize;
        int s;
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
        block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.Power_Normal.ordinal());
        float size = 0.5f;
        for (s = 0; s < 100; ++s) {
            this.displayPowerList[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.displayPowerList[s], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 100.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
        block.texture = BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.Power_Overload.ordinal());
        size = 0.5f;
        for (s = 0; s < 100; ++s) {
            this.displayPowerListOverload[s] = GLAllocation.func_74526_a((int)1);
            GL11.glNewList((int)this.displayPowerListOverload[s], (int)4864);
            minSize = 0.005f;
            unit = (size - minSize) / 2.0f / 100.0f;
            block.minY = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxY = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minZ = 0.5 - (double)(minSize / 2.0f) - (double)(unit * (float)s);
            block.maxZ = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            block.minX = 0.0;
            block.maxX = 0.5 + (double)(minSize / 2.0f) + (double)(unit * (float)s);
            RenderEntityBlock.INSTANCE.renderBlock(block, (IBlockAccess)world, 0, 0, 0, false, true);
            GL11.glEndList();
        }
    }

    public void func_76894_a(TileEntity tileentity, double x, double y, double z, float f) {
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        this.renderGatesWires(pipe, x, y, z);
        switch (pipe.getPipeType()) {
            case ITEM: {
                this.renderSolids(pipe.pipe, x, y, z);
                break;
            }
            case FLUID: {
                this.renderFluids(pipe.pipe, x, y, z);
                break;
            }
            case POWER: {
                this.renderPower(pipe.pipe, x, y, z);
            }
        }
    }

    private void renderGatesWires(TileGenericPipe pipe, double x, double y, double z) {
        PipeRenderState state = pipe.getRenderState();
        if (state.wireMatrix.hasWire(IPipe.WireColor.Red)) {
            this.pipeWireRender(pipe, 0.25f, 0.75f, 0.25f, IPipe.WireColor.Red, x, y, z);
        }
        if (state.wireMatrix.hasWire(IPipe.WireColor.Blue)) {
            this.pipeWireRender(pipe, 0.75f, 0.75f, 0.75f, IPipe.WireColor.Blue, x, y, z);
        }
        if (state.wireMatrix.hasWire(IPipe.WireColor.Green)) {
            this.pipeWireRender(pipe, 0.75f, 0.25f, 0.25f, IPipe.WireColor.Green, x, y, z);
        }
        if (state.wireMatrix.hasWire(IPipe.WireColor.Yellow)) {
            this.pipeWireRender(pipe, 0.25f, 0.25f, 0.75f, IPipe.WireColor.Yellow, x, y, z);
        }
        if (state.hasGate()) {
            this.pipeGateRender(pipe, x, y, z);
        }
    }

    private void pipeWireRender(TileGenericPipe pipe, float cx, float cy, float cz, IPipe.WireColor color, double x, double y, double z) {
        PipeRenderState state = pipe.getRenderState();
        float minX = 0.25f;
        float minY = 0.25f;
        float minZ = 0.25f;
        float maxX = 0.75f;
        float maxY = 0.75f;
        float maxZ = 0.75f;
        boolean foundX = false;
        boolean foundY = false;
        boolean foundZ = false;
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.WEST)) {
            minX = 0.0f;
            foundX = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.EAST)) {
            maxX = 1.0f;
            foundX = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.DOWN)) {
            minY = 0.0f;
            foundY = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.UP)) {
            maxY = 1.0f;
            foundY = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.NORTH)) {
            minZ = 0.0f;
            foundZ = true;
        }
        if (state.wireMatrix.isWireConnected(color, ForgeDirection.SOUTH)) {
            maxZ = 1.0f;
            foundZ = true;
        }
        boolean center = false;
        if (minX == 0.0f && maxX != 1.0f && (foundY || foundZ)) {
            if (cx == 0.25f) {
                maxX = 0.25f;
            } else {
                center = true;
            }
        }
        if (minX != 0.0f && maxX == 1.0f && (foundY || foundZ)) {
            if (cx == 0.75f) {
                minX = 0.75f;
            } else {
                center = true;
            }
        }
        if (minY == 0.0f && maxY != 1.0f && (foundX || foundZ)) {
            if (cy == 0.25f) {
                maxY = 0.25f;
            } else {
                center = true;
            }
        }
        if (minY != 0.0f && maxY == 1.0f && (foundX || foundZ)) {
            if (cy == 0.75f) {
                minY = 0.75f;
            } else {
                center = true;
            }
        }
        if (minZ == 0.0f && maxZ != 1.0f && (foundX || foundY)) {
            if (cz == 0.25f) {
                maxZ = 0.25f;
            } else {
                center = true;
            }
        }
        if (minZ != 0.0f && maxZ == 1.0f && (foundX || foundY)) {
            if (cz == 0.75f) {
                minZ = 0.75f;
            } else {
                center = true;
            }
        }
        boolean found = foundX || foundY || foundZ;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        RenderHelper.func_74518_a();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        float scale = 1.001f;
        GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
        this.func_110628_a(TextureMap.field_110575_b);
        RenderEntityBlock.RenderInfo box = new RenderEntityBlock.RenderInfo();
        box.texture = BuildCraftTransport.instance.wireIconProvider.getIcon(state.wireMatrix.getWireIconIndex(color));
        if (minZ != 0.25f || maxZ != 0.75f || !found) {
            box.setBounds(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, minZ, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), cy == 0.25f ? (double)cy : (double)(cy + 0.05f), maxZ);
            RenderEntityBlock.INSTANCE.renderBlock(box, (IBlockAccess)pipe.field_70331_k, 0.0, 0.0, 0.0, pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, true, true);
        }
        if (minX != 0.25f || maxX != 0.75f || !found) {
            box.setBounds(minX, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, maxX, cy == 0.25f ? (double)cy : (double)(cy + 0.05f), cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            RenderEntityBlock.INSTANCE.renderBlock(box, (IBlockAccess)pipe.field_70331_k, 0.0, 0.0, 0.0, pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, true, true);
        }
        if (minY != 0.25f || maxY != 0.75f || !found) {
            box.setBounds(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, minY, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), maxY, cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            RenderEntityBlock.INSTANCE.renderBlock(box, (IBlockAccess)pipe.field_70331_k, 0.0, 0.0, 0.0, pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, true, true);
        }
        if (center || !found) {
            box.setBounds(cx == 0.25f ? (double)(cx - 0.05f) : (double)cx, cy == 0.25f ? (double)(cy - 0.05f) : (double)cy, cz == 0.25f ? (double)(cz - 0.05f) : (double)cz, cx == 0.25f ? (double)cx : (double)(cx + 0.05f), cy == 0.25f ? (double)cy : (double)(cy + 0.05f), cz == 0.25f ? (double)cz : (double)(cz + 0.05f));
            RenderEntityBlock.INSTANCE.renderBlock(box, (IBlockAccess)pipe.field_70331_k, 0.0, 0.0, 0.0, pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, true, true);
        }
        RenderHelper.func_74519_b();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void pipeGateRender(TileGenericPipe pipe, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2884);
        RenderHelper.func_74518_a();
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_110628_a(TextureMap.field_110575_b);
        PipeRenderState state = pipe.getRenderState();
        float min = 0.3f;
        float max = 0.7f;
        RenderEntityBlock.RenderInfo box = new RenderEntityBlock.RenderInfo();
        box.texture = BuildCraftTransport.instance.gateIconProvider.getIcon(state.getGateIconIndex());
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.WEST)) {
            box.setBounds(0.15f, min, min, 0.251f, max, max);
            RenderEntityBlock.INSTANCE.renderBlock(box, (IBlockAccess)pipe.field_70331_k, 0.0, 0.0, 0.0, pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, true, true);
        }
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.EAST)) {
            box.setBounds(0.751f, min, min, 0.85f, max, max);
            RenderEntityBlock.INSTANCE.renderBlock(box, (IBlockAccess)pipe.field_70331_k, 0.0, 0.0, 0.0, pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, true, true);
        }
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.DOWN)) {
            box.setBounds(min, 0.15f, min, max, 0.251f, max);
            RenderEntityBlock.INSTANCE.renderBlock(box, (IBlockAccess)pipe.field_70331_k, 0.0, 0.0, 0.0, pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, true, true);
        }
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.UP)) {
            box.setBounds(min, 0.751f, min, max, 0.85f, max);
            RenderEntityBlock.INSTANCE.renderBlock(box, (IBlockAccess)pipe.field_70331_k, 0.0, 0.0, 0.0, pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, true, true);
        }
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.NORTH)) {
            box.setBounds(min, min, 0.15f, max, max, 0.251f);
            RenderEntityBlock.INSTANCE.renderBlock(box, (IBlockAccess)pipe.field_70331_k, 0.0, 0.0, 0.0, pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, true, true);
        }
        if (this.shouldRenderNormalPipeSide(state, ForgeDirection.SOUTH)) {
            box.setBounds(min, min, 0.751f, max, max, 0.85f);
            RenderEntityBlock.INSTANCE.renderBlock(box, (IBlockAccess)pipe.field_70331_k, 0.0, 0.0, 0.0, pipe.field_70329_l, pipe.field_70330_m, pipe.field_70327_n, true, true);
        }
        RenderHelper.func_74519_b();
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private boolean shouldRenderNormalPipeSide(PipeRenderState state, ForgeDirection direction) {
        return !state.pipeConnectionMatrix.isConnected(direction) && state.facadeMatrix.getFacadeBlockId(direction) == 0 && !state.plugMatrix.isConnected(direction) && !this.isOpenOrientation(state, direction);
    }

    public boolean isOpenOrientation(PipeRenderState state, ForgeDirection direction) {
        int connections = 0;
        ForgeDirection targetOrientation = ForgeDirection.UNKNOWN;
        for (ForgeDirection o : ForgeDirection.VALID_DIRECTIONS) {
            if (!state.pipeConnectionMatrix.isConnected(o) || ++connections != 1) continue;
            targetOrientation = o;
        }
        if (connections > 1 || connections == 0) {
            return false;
        }
        return targetOrientation.getOpposite() == direction;
    }

    private void renderPower(Pipe<PipeTransportPower> pipe, double x, double y, double z) {
        this.initializeDisplayPowerList(pipe.container.field_70331_k);
        PipeTransportPower pow = (PipeTransportPower)pipe.transport;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        this.func_110628_a(TextureMap.field_110575_b);
        int[] displayList = pow.overload > 0 ? this.displayPowerListOverload : this.displayPowerList;
        for (int side = 0; side < 6; ++side) {
            GL11.glPushMatrix();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
            GL11.glRotatef((float)this.angleY[side], (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glRotatef((float)this.angleZ[side], (float)0.0f, (float)0.0f, (float)1.0f);
            float scale = 1.0f - (float)side * 1.0E-4f;
            GL11.glScalef((float)scale, (float)scale, (float)scale);
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            short stage = pow.clientDisplayPower[side];
            if (stage >= 1) {
                if (stage < displayList.length) {
                    GL11.glCallList((int)displayList[stage]);
                } else {
                    GL11.glCallList((int)displayList[displayList.length - 1]);
                }
            }
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private void renderFluids(Pipe<PipeTransportFluids> pipe, double x, double y, double z) {
        DisplayFluidList d;
        PipeTransportFluids trans = (PipeTransportFluids)pipe.transport;
        boolean needsRender = false;
        for (int i = 0; i < 7; ++i) {
            FluidStack fluidStack = trans.renderCache[i];
            if (fluidStack == null || fluidStack.amount <= 0) continue;
            needsRender = true;
            break;
        }
        if (!needsRender) {
            return;
        }
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glEnable((int)2884);
        GL11.glDisable((int)2896);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        boolean sides = false;
        boolean above = false;
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            DisplayFluidList d2;
            int i = side.ordinal();
            FluidStack fluidStack = trans.renderCache[i];
            int color = trans.colorRenderCache[i];
            if (fluidStack == null || fluidStack.amount <= 0 || !pipe.container.isPipeConnected(side) || (d2 = this.getListFromBuffer(fluidStack, pipe.container.field_70331_k)) == null) continue;
            int stage = (int)((float)fluidStack.amount / (float)trans.getCapacity() * 39.0f);
            GL11.glPushMatrix();
            int list = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[i]) {
                case UP: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case DOWN: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case EAST: 
                case WEST: 
                case SOUTH: 
                case NORTH: {
                    sides = true;
                    GL11.glTranslatef((float)0.5f, (float)0.0f, (float)0.5f);
                    GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    GL11.glTranslatef((float)-0.5f, (float)0.0f, (float)-0.5f);
                    list = d2.sideHorizontal[stage];
                    break;
                }
            }
            this.func_110628_a(TextureMap.field_110575_b);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        FluidStack fluidStack = trans.renderCache[ForgeDirection.UNKNOWN.ordinal()];
        int color = trans.colorRenderCache[ForgeDirection.UNKNOWN.ordinal()];
        if (fluidStack != null && fluidStack.amount > 0 && (d = this.getListFromBuffer(fluidStack, pipe.container.field_70331_k)) != null) {
            int stage = (int)((float)fluidStack.amount / (float)trans.getCapacity() * 39.0f);
            this.func_110628_a(TextureMap.field_110575_b);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            GL11.glColor4f((float)red, (float)green, (float)blue, (float)1.0f);
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    private DisplayFluidList getListFromBuffer(FluidStack stack, World world) {
        int liquidId = stack.fluidID;
        if (liquidId == 0) {
            return null;
        }
        return this.getDisplayFluidLists(liquidId, world);
    }

    private void renderSolids(Pipe<PipeTransportItems> pipe, double x, double y, double z) {
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        float light = pipe.container.field_70331_k.func_72801_o(pipe.container.field_70329_l, pipe.container.field_70330_m, pipe.container.field_70327_n);
        int count = 0;
        for (TravelingItem item : ((PipeTransportItems)pipe.transport).items) {
            if (count >= 10) break;
            this.doRenderItem(item, x + item.xCoord - (double)pipe.container.field_70329_l, y + item.yCoord - (double)pipe.container.field_70330_m, z + item.zCoord - (double)pipe.container.field_70327_n, light, item.color);
            ++count;
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    public void doRenderItem(TravelingItem travellingItem, double x, double y, double z, float light, EnumColor color) {
        if (travellingItem == null || travellingItem.getItemStack() == null) {
            return;
        }
        float renderScale = 0.7f;
        ItemStack itemstack = travellingItem.getItemStack();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)x), (float)((float)y), (float)((float)z));
        GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
        GL11.glScalef((float)renderScale, (float)renderScale, (float)renderScale);
        this.dummyEntityItem.func_92058_a(itemstack);
        this.customRenderItem.func_77014_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
        if (color != null) {
            this.func_110628_a(TextureMap.field_110575_b);
            RenderEntityBlock.RenderInfo block = new RenderEntityBlock.RenderInfo();
            block.texture = PipeIconProvider.TYPE.ItemBox.getIcon();
            float pix = 0.0625f;
            float min = -4.0f * pix;
            float max = 4.0f * pix;
            block.minY = min;
            block.maxY = max;
            block.minZ = min;
            block.maxZ = max;
            block.minX = min;
            block.maxX = max;
            int cHex = color.getLightHex();
            float r = (float)(cHex >> 16 & 0xFF) / 255.0f;
            float g = (float)(cHex >> 8 & 0xFF) / 255.0f;
            float b = (float)(cHex & 0xFF) / 255.0f;
            GL11.glColor4f((float)r, (float)g, (float)b, (float)1.0f);
            RenderEntityBlock.INSTANCE.renderBlock(block, null, 0, 0, 0, false, true);
        }
        GL11.glPopMatrix();
    }

    private class DisplayFluidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayFluidList() {
        }
    }
}

