/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport;

import buildcraft.BuildCraftTransport;
import buildcraft.api.tools.IToolWrench;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.ISolidSideTile;
import buildcraft.core.BlockBuildCraft;
import buildcraft.core.BlockIndex;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BCLog;
import buildcraft.core.utils.MatrixTranformations;
import buildcraft.core.utils.Utils;
import buildcraft.transport.Gate;
import buildcraft.transport.IPipeRenderState;
import buildcraft.transport.ItemFacade;
import buildcraft.transport.ItemGate;
import buildcraft.transport.ItemPipe;
import buildcraft.transport.ItemPlug;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeIconProvider;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.TransportProxy;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EffectRenderer;
import net.minecraft.client.particle.EntityDiggingFX;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Icon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class BlockGenericPipe
extends BlockBuildCraft {
    private static final ForgeDirection[] DIR_VALUES = ForgeDirection.values();
    private boolean skippedFirstIconRegister;
    private int renderMask = 0;
    public static Map<Integer, Class<? extends Pipe>> pipes = new HashMap<Integer, Class<? extends Pipe>>();
    static long lastRemovedDate = -1L;
    public static Map<BlockIndex, Pipe> pipeRemoved = new HashMap<BlockIndex, Pipe>();
    public static int facadeRenderColor = -1;

    public BlockGenericPipe(int i) {
        super(i, Material.field_76264_q);
        this.setRenderAllSides();
        this.func_71849_a(null);
    }

    public float func_71934_m(World par1World, int par2, int par3, int par4) {
        return BuildCraftTransport.pipeDurability;
    }

    public int func_71857_b() {
        return TransportProxy.pipeModel;
    }

    public boolean func_71926_d() {
        return false;
    }

    public boolean canBeReplacedByLeaves(World world, int x, int y, int z) {
        return false;
    }

    public boolean func_71886_c() {
        return false;
    }

    public void setRenderMask(int mask) {
        this.renderMask = mask;
    }

    public final void setRenderAllSides() {
        this.renderMask = 63;
    }

    public void setRenderSide(ForgeDirection side, boolean render) {
        this.renderMask = render ? (this.renderMask |= 1 << side.ordinal()) : (this.renderMask &= ~(1 << side.ordinal()));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_71877_c(IBlockAccess blockAccess, int x, int y, int z, int side) {
        return (this.renderMask & 1 << side) != 0;
    }

    public boolean isBlockSolidOnSide(World world, int x, int y, int z, ForgeDirection side) {
        TileEntity tile = world.func_72796_p(x, y, z);
        if (tile instanceof ISolidSideTile) {
            return ((ISolidSideTile)tile).isSolidOnSide(side);
        }
        return false;
    }

    public boolean isACube() {
        return false;
    }

    public void func_71871_a(World world, int i, int j, int k, AxisAlignedBB axisalignedbb, List arraylist, Entity par7Entity) {
        this.func_71905_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
        super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
        TileEntity tile1 = world.func_72796_p(i, j, k);
        if (tile1 instanceof TileGenericPipe) {
            TileGenericPipe tileG = (TileGenericPipe)tile1;
            if (tileG.isPipeConnected(ForgeDirection.WEST)) {
                this.func_71905_a(0.0f, 0.25f, 0.25f, 0.75f, 0.75f, 0.75f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.EAST)) {
                this.func_71905_a(0.25f, 0.25f, 0.25f, 1.0f, 0.75f, 0.75f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.DOWN)) {
                this.func_71905_a(0.25f, 0.0f, 0.25f, 0.75f, 0.75f, 0.75f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.UP)) {
                this.func_71905_a(0.25f, 0.25f, 0.25f, 0.75f, 1.0f, 0.75f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.NORTH)) {
                this.func_71905_a(0.25f, 0.25f, 0.0f, 0.75f, 0.75f, 0.75f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.isPipeConnected(ForgeDirection.SOUTH)) {
                this.func_71905_a(0.25f, 0.25f, 0.25f, 0.75f, 0.75f, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            float facadeThickness = 0.125f;
            if (tileG.hasFacade(ForgeDirection.EAST)) {
                this.func_71905_a(1.0f - facadeThickness, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasFacade(ForgeDirection.WEST)) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, facadeThickness, 1.0f, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasFacade(ForgeDirection.UP)) {
                this.func_71905_a(0.0f, 1.0f - facadeThickness, 0.0f, 1.0f, 1.0f, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasFacade(ForgeDirection.DOWN)) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, facadeThickness, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasFacade(ForgeDirection.SOUTH)) {
                this.func_71905_a(0.0f, 0.0f, 1.0f - facadeThickness, 1.0f, 1.0f, 1.0f);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
            if (tileG.hasFacade(ForgeDirection.NORTH)) {
                this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, facadeThickness);
                super.func_71871_a(world, i, j, k, axisalignedbb, arraylist, par7Entity);
            }
        }
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_71911_a_(World world, int x, int y, int z) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null) {
            AxisAlignedBB box = rayTraceResult.boundingBox;
            switch (rayTraceResult.hitPart) {
                case Gate: 
                case Plug: {
                    float scale = 0.001f;
                    box = box.func_72314_b((double)scale, (double)scale, (double)scale);
                    break;
                }
                case Pipe: {
                    float scale = 0.08f;
                    box = box.func_72314_b((double)scale, (double)scale, (double)scale);
                    break;
                }
            }
            return box.func_72325_c((double)x, (double)y, (double)z);
        }
        return super.func_71911_a_(world, x, y, z).func_72314_b((double)-0.85f, (double)-0.85f, (double)-0.85f);
    }

    public MovingObjectPosition func_71878_a(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        RaytraceResult raytraceResult = this.doRayTrace(world, x, y, z, origin, direction);
        if (raytraceResult == null) {
            return null;
        }
        return raytraceResult.movingObjectPosition;
    }

    private RaytraceResult doRayTrace(World world, int x, int y, int z, EntityPlayer player) {
        double reachDistance = 5.0;
        if (player instanceof EntityPlayerMP) {
            reachDistance = ((EntityPlayerMP)player).field_71134_c.getBlockReachDistance();
        }
        double eyeHeight = world.field_72995_K ? (double)(player.func_70047_e() - player.getDefaultEyeHeight()) : (double)player.func_70047_e();
        Vec3 lookVec = player.func_70040_Z();
        Vec3 origin = world.func_82732_R().func_72345_a(player.field_70165_t, player.field_70163_u + eyeHeight, player.field_70161_v);
        Vec3 direction = origin.func_72441_c(lookVec.field_72450_a * reachDistance, lookVec.field_72448_b * reachDistance, lookVec.field_72449_c * reachDistance);
        return this.doRayTrace(world, x, y, z, origin, direction);
    }

    private RaytraceResult doRayTrace(World world, int x, int y, int z, Vec3 origin, Vec3 direction) {
        AxisAlignedBB bb;
        TileEntity pipeTileEntity = world.func_72796_p(x, y, z);
        TileGenericPipe tileG = null;
        if (pipeTileEntity instanceof TileGenericPipe) {
            tileG = (TileGenericPipe)pipeTileEntity;
        }
        if (tileG == null) {
            return null;
        }
        Pipe pipe = tileG.pipe;
        if (!BlockGenericPipe.isValid(pipe)) {
            return null;
        }
        MovingObjectPosition[] hits = new MovingObjectPosition[25];
        AxisAlignedBB[] boxes = new AxisAlignedBB[25];
        Object[] sideHit = new ForgeDirection[25];
        Arrays.fill(sideHit, ForgeDirection.UNKNOWN);
        for (ForgeDirection side : DIR_VALUES) {
            if (side != ForgeDirection.UNKNOWN && !tileG.isPipeConnected(side)) continue;
            bb = this.getPipeBoundingBox(side);
            this.setBlockBounds(bb);
            boxes[side.ordinal()] = bb;
            hits[side.ordinal()] = super.func_71878_a(world, x, y, z, origin, direction);
            sideHit[side.ordinal()] = side;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!pipe.hasGate(side)) continue;
            bb = this.getGateBoundingBox(side);
            this.setBlockBounds(bb);
            boxes[7 + side.ordinal()] = bb;
            hits[7 + side.ordinal()] = super.func_71878_a(world, x, y, z, origin, direction);
            sideHit[7 + side.ordinal()] = side;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!tileG.hasFacade(side)) continue;
            bb = this.getFacadeBoundingBox(side);
            this.setBlockBounds(bb);
            boxes[13 + side.ordinal()] = bb;
            hits[13 + side.ordinal()] = super.func_71878_a(world, x, y, z, origin, direction);
            sideHit[13 + side.ordinal()] = side;
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            if (!tileG.hasPlug(side)) continue;
            bb = this.getPlugBoundingBox(side);
            this.setBlockBounds(bb);
            boxes[19 + side.ordinal()] = bb;
            hits[19 + side.ordinal()] = super.func_71878_a(world, x, y, z, origin, direction);
            sideHit[19 + side.ordinal()] = side;
        }
        double minLengthSquared = Double.POSITIVE_INFINITY;
        int minIndex = -1;
        for (int i = 0; i < hits.length; ++i) {
            double lengthSquared;
            MovingObjectPosition hit = hits[i];
            if (hit == null || !((lengthSquared = hit.field_72307_f.func_72436_e(origin)) < minLengthSquared)) continue;
            minLengthSquared = lengthSquared;
            minIndex = i;
        }
        this.func_71905_a(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        if (minIndex == -1) {
            return null;
        }
        Part hitPart = minIndex < 7 ? Part.Pipe : (minIndex < 13 ? Part.Gate : (minIndex < 19 ? Part.Facade : Part.Plug));
        return new RaytraceResult(hitPart, hits[minIndex], boxes[minIndex], (ForgeDirection)sideHit[minIndex]);
    }

    private void setBlockBounds(AxisAlignedBB bb) {
        this.func_71905_a((float)bb.field_72340_a, (float)bb.field_72338_b, (float)bb.field_72339_c, (float)bb.field_72336_d, (float)bb.field_72337_e, (float)bb.field_72334_f);
    }

    private AxisAlignedBB getGateBoundingBox(ForgeDirection side) {
        float min = 0.3f;
        float max = 0.7f;
        float[][] bounds = new float[3][2];
        bounds[0][0] = min;
        bounds[0][1] = max;
        bounds[1][0] = 0.15f;
        bounds[1][1] = 0.25f;
        bounds[2][0] = min;
        bounds[2][1] = max;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72332_a().func_72299_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    private AxisAlignedBB getFacadeBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.0f;
        bounds[0][1] = 1.0f;
        bounds[1][0] = 0.0f;
        bounds[1][1] = 0.125f;
        bounds[2][0] = 0.0f;
        bounds[2][1] = 1.0f;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72332_a().func_72299_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    private AxisAlignedBB getPlugBoundingBox(ForgeDirection side) {
        float[][] bounds = new float[3][2];
        bounds[0][0] = 0.25f;
        bounds[0][1] = 0.75f;
        bounds[1][0] = 0.125f;
        bounds[1][1] = 0.251f;
        bounds[2][0] = 0.25f;
        bounds[2][1] = 0.75f;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72332_a().func_72299_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    private AxisAlignedBB getPipeBoundingBox(ForgeDirection side) {
        float min = 0.25f;
        float max = 0.75f;
        if (side == ForgeDirection.UNKNOWN) {
            return AxisAlignedBB.func_72332_a().func_72299_a((double)min, (double)min, (double)min, (double)max, (double)max, (double)max);
        }
        float[][] bounds = new float[3][2];
        bounds[0][0] = min;
        bounds[0][1] = max;
        bounds[1][0] = 0.0f;
        bounds[1][1] = min;
        bounds[2][0] = min;
        bounds[2][1] = max;
        MatrixTranformations.transform(bounds, side);
        return AxisAlignedBB.func_72332_a().func_72299_a((double)bounds[0][0], (double)bounds[1][0], (double)bounds[2][0], (double)bounds[0][1], (double)bounds[1][1], (double)bounds[2][1]);
    }

    public static void removePipe(Pipe pipe) {
        World world;
        if (pipe == null) {
            return;
        }
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onBlockRemoval();
        }
        if ((world = pipe.container.field_70331_k) == null) {
            return;
        }
        int x = pipe.container.field_70329_l;
        int y = pipe.container.field_70330_m;
        int z = pipe.container.field_70327_n;
        if (lastRemovedDate != world.func_82737_E()) {
            lastRemovedDate = world.func_82737_E();
            pipeRemoved.clear();
        }
        pipeRemoved.put(new BlockIndex(x, y, z), pipe);
        world.func_72932_q(x, y, z);
    }

    @Override
    public void func_71852_a(World world, int x, int y, int z, int par5, int par6) {
        Utils.preDestroyBlock(world, x, y, z);
        BlockGenericPipe.removePipe(BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z));
        super.func_71852_a(world, x, y, z, par5, par6);
    }

    public ArrayList<ItemStack> getBlockDropped(World world, int x, int y, int z, int metadata, int fortune) {
        if (CoreProxy.proxy.isRenderWorld(world)) {
            return null;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        int count = this.quantityDropped(metadata, fortune, world.field_73012_v);
        for (int i = 0; i < count; ++i) {
            Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
            if (pipe == null) {
                pipe = pipeRemoved.get(new BlockIndex(x, y, z));
            }
            if (pipe == null || pipe.itemID <= 0) continue;
            pipe.dropContents();
            list.add(new ItemStack(pipe.itemID, 1, this.func_71899_b(metadata)));
        }
        return list;
    }

    public TileEntity func_72274_a(World var1) {
        return new TileGenericPipe();
    }

    public void func_71914_a(World world, int i, int j, int k, int l, float f, int dmg) {
        if (CoreProxy.proxy.isRenderWorld(world)) {
            return;
        }
        int i1 = this.func_71925_a(world.field_73012_v);
        for (int j1 = 0; j1 < i1; ++j1) {
            int k1;
            if (world.field_73012_v.nextFloat() > f) continue;
            Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
            if (pipe == null) {
                pipe = pipeRemoved.get(new BlockIndex(i, j, k));
            }
            if (pipe == null || (k1 = pipe.itemID) <= 0) continue;
            pipe.dropContents();
            this.func_71929_a(world, i, j, k, new ItemStack(k1, 1, this.func_71899_b(l)));
        }
    }

    public int func_71885_a(int meta, Random rand, int dmg) {
        return 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71922_a(World world, int i, int j, int k) {
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
        if (pipe == null) {
            return 0;
        }
        return pipe.itemID;
    }

    @SideOnly(value=Side.CLIENT)
    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        if (rayTraceResult != null && rayTraceResult.boundingBox != null) {
            switch (rayTraceResult.hitPart) {
                case Gate: {
                    Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
                    return pipe.gate.getGateItem();
                }
                case Plug: {
                    return new ItemStack(BuildCraftTransport.plugItem);
                }
            }
        }
        return super.getPickBlock(target, world, x, y, z);
    }

    public void func_71863_a(World world, int x, int y, int z, int id) {
        super.func_71863_a(world, x, y, z, id);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.container.scheduleNeighborChange();
            pipe.container.redstonePowered = world.func_72864_z(x, y, z);
        }
    }

    public int func_85104_a(World world, int x, int y, int z, int side, float par6, float par7, float par8, int meta) {
        super.func_85104_a(world, x, y, z, side, par6, par7, par8, meta);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlaced();
        }
        return meta;
    }

    @Override
    public void func_71860_a(World world, int x, int y, int z, EntityLivingBase placer, ItemStack stack) {
        super.func_71860_a(world, x, y, z, placer, stack);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onBlockPlacedBy(placer);
        }
    }

    public boolean func_71903_a(World world, int x, int y, int z, EntityPlayer player, int side, float xOffset, float yOffset, float zOffset) {
        super.func_71903_a(world, x, y, z, player, side, xOffset, yOffset, zOffset);
        world.func_72898_h(x, y, z, BuildCraftTransport.genericPipeBlock.field_71990_ca);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            RaytraceResult rayTraceResult;
            ItemStack currentItem = player.func_71045_bC();
            if (player.func_70093_af() && currentItem == null) {
                if (this.stripEquipment(world, x, y, z, player, pipe)) {
                    return true;
                }
            } else if (currentItem != null) {
                if (currentItem.field_77993_c == Item.field_77792_au.field_77779_bT) {
                    return false;
                }
                if (currentItem.func_77973_b() instanceof ItemPipe) {
                    return false;
                }
                if (currentItem.func_77973_b() instanceof IToolWrench) {
                    return pipe.blockActivated(player);
                }
                if (currentItem.func_77973_b() == BuildCraftTransport.redPipeWire ? this.addOrStripWire(player, pipe, IPipe.WireColor.Red) : (currentItem.func_77973_b() == BuildCraftTransport.bluePipeWire ? this.addOrStripWire(player, pipe, IPipe.WireColor.Blue) : (currentItem.func_77973_b() == BuildCraftTransport.greenPipeWire ? this.addOrStripWire(player, pipe, IPipe.WireColor.Green) : (currentItem.func_77973_b() == BuildCraftTransport.yellowPipeWire ? this.addOrStripWire(player, pipe, IPipe.WireColor.Yellow) : (currentItem.func_77973_b() instanceof ItemGate ? this.addOrStripGate(world, x, y, z, player, pipe) : (currentItem.func_77973_b() instanceof ItemPlug ? this.addOrStripPlug(world, x, y, z, player, ForgeDirection.getOrientation((int)side), pipe) : currentItem.func_77973_b() instanceof ItemFacade && this.addOrStripFacade(world, x, y, z, player, ForgeDirection.getOrientation((int)side), pipe))))))) {
                    return true;
                }
            }
            boolean clickedOnGate = false;
            if (pipe.hasGate() && (rayTraceResult = this.doRayTrace(world, x, y, z, player)) != null && rayTraceResult.hitPart == Part.Gate) {
                clickedOnGate = true;
            }
            if (clickedOnGate) {
                pipe.gate.openGui(player);
                return true;
            }
            return pipe.blockActivated(player);
        }
        return false;
    }

    private boolean addOrStripGate(World world, int x, int y, int z, EntityPlayer player, Pipe pipe) {
        RaytraceResult rayTraceResult;
        if (this.addGate(player, pipe)) {
            return true;
        }
        return player.func_70093_af() && (rayTraceResult = this.doRayTrace(world, x, y, z, player)) != null && rayTraceResult.hitPart == Part.Gate && this.stripGate(pipe);
    }

    private boolean addGate(EntityPlayer player, Pipe pipe) {
        if (!pipe.hasGate()) {
            pipe.gate = Gate.makeGate(pipe, player.func_71045_bC());
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_71045_bC().func_77979_a(1);
            }
            pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    private boolean stripGate(Pipe pipe) {
        if (pipe.hasGate()) {
            if (!CoreProxy.proxy.isRenderWorld(pipe.container.field_70331_k)) {
                pipe.gate.dropGate();
            }
            pipe.resetGate();
            return true;
        }
        return false;
    }

    private boolean addOrStripWire(EntityPlayer player, Pipe pipe, IPipe.WireColor color) {
        if (this.addWire(pipe, color)) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_71045_bC().func_77979_a(1);
            }
            return true;
        }
        return player.func_70093_af() && this.stripWire(pipe, color);
    }

    private boolean addWire(Pipe pipe, IPipe.WireColor color) {
        if (!pipe.wireSet[color.ordinal()]) {
            pipe.wireSet[color.ordinal()] = true;
            pipe.signalStrength[color.ordinal()] = 0;
            pipe.container.scheduleNeighborChange();
            return true;
        }
        return false;
    }

    private boolean stripWire(Pipe pipe, IPipe.WireColor color) {
        if (pipe.wireSet[color.ordinal()]) {
            if (!CoreProxy.proxy.isRenderWorld(pipe.container.field_70331_k)) {
                this.dropWire(color, pipe);
            }
            pipe.wireSet[color.ordinal()] = false;
            pipe.container.scheduleRenderUpdate();
            return true;
        }
        return false;
    }

    private boolean addOrStripFacade(World world, int x, int y, int z, EntityPlayer player, ForgeDirection side, Pipe pipe) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, player);
        if (player.func_70093_af() && rayTraceResult != null && rayTraceResult.hitPart == Part.Facade && this.stripFacade(pipe, rayTraceResult.sideHit)) {
            return true;
        }
        return rayTraceResult != null && rayTraceResult.hitPart != Part.Facade && this.addFacade(player, pipe, rayTraceResult.sideHit != null && rayTraceResult.sideHit != ForgeDirection.UNKNOWN ? rayTraceResult.sideHit : side);
    }

    private boolean addFacade(EntityPlayer player, Pipe pipe, ForgeDirection side) {
        ItemStack stack = player.func_71045_bC();
        if (pipe.container.addFacade(side, ItemFacade.getBlockId(stack), ItemFacade.getMetaData(stack))) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    private boolean stripFacade(Pipe pipe, ForgeDirection side) {
        return pipe.container.dropFacade(side);
    }

    private boolean addOrStripPlug(World world, int x, int y, int z, EntityPlayer player, ForgeDirection side, Pipe pipe) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, player);
        if (player.func_70093_af() && rayTraceResult != null && rayTraceResult.hitPart == Part.Plug && this.stripPlug(pipe, rayTraceResult.sideHit)) {
            return true;
        }
        return rayTraceResult != null && (rayTraceResult.hitPart == Part.Pipe || rayTraceResult.hitPart == Part.Gate) && this.addPlug(player, pipe, rayTraceResult.sideHit != null && rayTraceResult.sideHit != ForgeDirection.UNKNOWN ? rayTraceResult.sideHit : side);
    }

    private boolean addPlug(EntityPlayer player, Pipe pipe, ForgeDirection side) {
        ItemStack stack = player.func_71045_bC();
        if (pipe.container.addPlug(side)) {
            if (!player.field_71075_bZ.field_75098_d) {
                --stack.field_77994_a;
            }
            return true;
        }
        return false;
    }

    private boolean stripPlug(Pipe pipe, ForgeDirection side) {
        return pipe.container.removeAndDropPlug(side);
    }

    private boolean stripEquipment(World world, int x, int y, int z, EntityPlayer player, Pipe pipe) {
        RaytraceResult rayTraceResult = this.doRayTrace(world, x, y, z, player);
        if (rayTraceResult != null && rayTraceResult.hitPart == Part.Facade && this.stripFacade(pipe, rayTraceResult.sideHit)) {
            return true;
        }
        for (IPipe.WireColor color : IPipe.WireColor.values()) {
            if (!this.stripWire(pipe, color)) continue;
            return true;
        }
        return this.stripGate(pipe);
    }

    private void dropWire(IPipe.WireColor color, Pipe pipe) {
        Item wireItem;
        switch (color) {
            case Red: {
                wireItem = BuildCraftTransport.redPipeWire;
                break;
            }
            case Blue: {
                wireItem = BuildCraftTransport.bluePipeWire;
                break;
            }
            case Green: {
                wireItem = BuildCraftTransport.greenPipeWire;
                break;
            }
            default: {
                wireItem = BuildCraftTransport.yellowPipeWire;
            }
        }
        pipe.dropItem(new ItemStack(wireItem));
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71895_b(IBlockAccess iblockaccess, int x, int y, int z, int side) {
        TileEntity tile = iblockaccess.func_72796_p(x, y, z);
        if (!(tile instanceof IPipeRenderState)) {
            return null;
        }
        if (((IPipeRenderState)tile).getRenderState().textureArray != null) {
            return ((IPipeRenderState)tile).getRenderState().textureArray[side];
        }
        return ((IPipeRenderState)tile).getRenderState().currentTexture;
    }

    public void func_71869_a(World world, int i, int j, int k, Entity entity) {
        super.func_71869_a(world, i, j, k, entity);
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.onEntityCollidedWithBlock(entity);
        }
    }

    public boolean canConnectRedstone(IBlockAccess world, int x, int y, int z, int side) {
        Pipe pipe = BlockGenericPipe.getPipe(world, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.canConnectRedstone();
        }
        return false;
    }

    public int func_71855_c(IBlockAccess iblockaccess, int x, int y, int z, int l) {
        Pipe pipe = BlockGenericPipe.getPipe(iblockaccess, x, y, z);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.isPoweringTo(l);
        }
        return 0;
    }

    public boolean func_71853_i() {
        return true;
    }

    public int func_71865_a(IBlockAccess world, int i, int j, int k, int l) {
        Pipe pipe = BlockGenericPipe.getPipe(world, i, j, k);
        if (BlockGenericPipe.isValid(pipe)) {
            return pipe.isIndirectlyPoweringTo(l);
        }
        return 0;
    }

    public void func_71862_a(World world, int i, int j, int k, Random random) {
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)world, i, j, k);
        if (BlockGenericPipe.isValid(pipe)) {
            pipe.randomDisplayTick(random);
        }
    }

    public static ItemPipe registerPipe(int key, Class<? extends Pipe> clas) {
        ItemPipe item = new ItemPipe(key);
        item.func_77655_b("buildcraftPipe." + clas.getSimpleName().toLowerCase(Locale.ENGLISH));
        GameRegistry.registerItem((Item)item, (String)item.func_77658_a());
        pipes.put(item.field_77779_bT, clas);
        Pipe dummyPipe = BlockGenericPipe.createPipe(item.field_77779_bT);
        if (dummyPipe != null) {
            item.setPipeIconIndex(dummyPipe.getIconIndexForItem());
            TransportProxy.proxy.setIconProviderFromPipe(item, dummyPipe);
        }
        return item;
    }

    public static boolean isPipeRegistered(int key) {
        return pipes.containsKey(key);
    }

    public static Pipe createPipe(int key) {
        try {
            Class<? extends Pipe> pipe = pipes.get(key);
            if (pipe != null) {
                return pipe.getConstructor(Integer.TYPE).newInstance(key);
            }
            BCLog.logger.warning("Detected pipe with unknown key (" + key + "). Did you remove a buildcraft addon?");
        }
        catch (Throwable t) {
            BCLog.logger.warning("Failed to create pipe with (" + key + "). No valid constructor found. Possibly a item ID conflit.");
        }
        return null;
    }

    public static boolean placePipe(Pipe pipe, World world, int i, int j, int k, int blockId, int meta) {
        if (world.field_72995_K) {
            return true;
        }
        boolean placed = world.func_72832_d(i, j, k, blockId, meta, 3);
        if (placed) {
            TileGenericPipe tile = (TileGenericPipe)world.func_72796_p(i, j, k);
            tile.initialize(pipe);
            tile.sendUpdateToClient();
        }
        return placed;
    }

    public static Pipe getPipe(IBlockAccess blockAccess, int i, int j, int k) {
        TileEntity tile = blockAccess.func_72796_p(i, j, k);
        if (!(tile instanceof TileGenericPipe) || tile.func_70320_p()) {
            return null;
        }
        return ((TileGenericPipe)tile).pipe;
    }

    public static boolean isFullyDefined(Pipe pipe) {
        return pipe != null && pipe.transport != null;
    }

    public static boolean isValid(Pipe pipe) {
        return BlockGenericPipe.isFullyDefined(pipe);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister iconRegister) {
        if (!this.skippedFirstIconRegister) {
            this.skippedFirstIconRegister = true;
            return;
        }
        BuildCraftTransport.instance.gateIconProvider.registerIcons(iconRegister);
        BuildCraftTransport.instance.wireIconProvider.registerIcons(iconRegister);
        for (int i : pipes.keySet()) {
            Pipe dummyPipe = BlockGenericPipe.createPipe(i);
            if (dummyPipe == null) continue;
            dummyPipe.getIconProvider().registerIcons(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public Icon func_71858_a(int par1, int par2) {
        return BuildCraftTransport.instance.pipeIconProvider.getIcon(PipeIconProvider.TYPE.Stripes.ordinal());
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockHitEffects(World worldObj, MovingObjectPosition target, EffectRenderer effectRenderer) {
        int x = target.field_72311_b;
        int y = target.field_72312_c;
        int z = target.field_72309_d;
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)worldObj, x, y, z);
        if (pipe == null) {
            return false;
        }
        Icon icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        int sideHit = target.field_72310_e;
        BlockGenericPipe block = BuildCraftTransport.genericPipeBlock;
        float b = 0.1f;
        double px = (double)x + this.rand.nextDouble() * (block.func_83007_w() - block.func_83009_v() - (double)(b * 2.0f)) + (double)b + block.func_83009_v();
        double py = (double)y + this.rand.nextDouble() * (block.func_83010_y() - block.func_83008_x() - (double)(b * 2.0f)) + (double)b + block.func_83008_x();
        double pz = (double)z + this.rand.nextDouble() * (block.func_83006_A() - block.func_83005_z() - (double)(b * 2.0f)) + (double)b + block.func_83005_z();
        if (sideHit == 0) {
            py = (double)y + block.func_83008_x() - (double)b;
        }
        if (sideHit == 1) {
            py = (double)y + block.func_83010_y() + (double)b;
        }
        if (sideHit == 2) {
            pz = (double)z + block.func_83005_z() - (double)b;
        }
        if (sideHit == 3) {
            pz = (double)z + block.func_83006_A() + (double)b;
        }
        if (sideHit == 4) {
            px = (double)x + block.func_83009_v() - (double)b;
        }
        if (sideHit == 5) {
            px = (double)x + block.func_83007_w() + (double)b;
        }
        EntityDiggingFX fx = new EntityDiggingFX(worldObj, px, py, pz, 0.0, 0.0, 0.0, (Block)block, sideHit, worldObj.func_72805_g(x, y, z));
        fx.func_110125_a(icon);
        effectRenderer.func_78873_a(fx.func_70596_a(x, y, z).func_70543_e(0.2f).func_70541_f(0.6f));
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean addBlockDestroyEffects(World worldObj, int x, int y, int z, int meta, EffectRenderer effectRenderer) {
        Pipe pipe = BlockGenericPipe.getPipe((IBlockAccess)worldObj, x, y, z);
        if (pipe == null) {
            return false;
        }
        Icon icon = pipe.getIconProvider().getIcon(pipe.getIconIndexForItem());
        int its = 4;
        for (int i = 0; i < its; ++i) {
            for (int j = 0; j < its; ++j) {
                for (int k = 0; k < its; ++k) {
                    double px = (double)x + ((double)i + 0.5) / (double)its;
                    double py = (double)y + ((double)j + 0.5) / (double)its;
                    double pz = (double)z + ((double)k + 0.5) / (double)its;
                    int random = this.rand.nextInt(6);
                    EntityDiggingFX fx = new EntityDiggingFX(worldObj, px, py, pz, px - (double)x - 0.5, py - (double)y - 0.5, pz - (double)z - 0.5, (Block)BuildCraftTransport.genericPipeBlock, random, meta);
                    fx.func_110125_a(icon);
                    effectRenderer.func_78873_a((EntityFX)fx.func_70596_a(x, y, z));
                }
            }
        }
        return true;
    }

    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        if (facadeRenderColor != -1) {
            return facadeRenderColor;
        }
        return super.func_71920_b(world, x, y, z);
    }

    static class RaytraceResult {
        public final Part hitPart;
        public final MovingObjectPosition movingObjectPosition;
        public final AxisAlignedBB boundingBox;
        public final ForgeDirection sideHit;

        RaytraceResult(Part hitPart, MovingObjectPosition movingObjectPosition, AxisAlignedBB boundingBox, ForgeDirection side) {
            this.hitPart = hitPart;
            this.movingObjectPosition = movingObjectPosition;
            this.boundingBox = boundingBox;
            this.sideHit = side;
        }

        public String toString() {
            return String.format("RayTraceResult: %s, %s", this.hitPart == null ? "null" : this.hitPart.name(), this.boundingBox == null ? "null" : this.boundingBox.toString());
        }
    }

    static enum Part {
        Pipe,
        Gate,
        Facade,
        Plug;

    }
}

