/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.energy;

import buildcraft.BuildCraftCore;
import buildcraft.BuildCraftEnergy;
import buildcraft.api.gates.ITrigger;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.energy.TileEngineWithInventory;
import buildcraft.energy.gui.ContainerEngine;
import java.util.LinkedList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ForgeDirection;

public class TileEngineStone
extends TileEngineWithInventory {
    final float MAX_OUTPUT = 1.0f;
    final float MIN_OUTPUT = 0.33333334f;
    final float TARGET_OUTPUT = 0.375f;
    final float kp = 1.0f;
    final float ki = 0.05f;
    final float eLimit = 13.333332f;
    int burnTime = 0;
    int totalBurnTime = 0;
    float esum = 0.0f;

    public TileEngineStone() {
        super(1);
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player, ForgeDirection side) {
        if (!CoreProxy.proxy.isRenderWorld(this.field_70331_k)) {
            player.openGui((Object)BuildCraftEnergy.instance, 21, this.field_70331_k, this.field_70329_l, this.field_70330_m, this.field_70327_n);
        }
        return true;
    }

    @Override
    public ResourceLocation getTextureFile() {
        return STONE_TEXTURE;
    }

    @Override
    public float explosionRange() {
        return 2.0f;
    }

    @Override
    public boolean isBurning() {
        return this.burnTime > 0;
    }

    @Override
    public void burn() {
        if (this.burnTime > 0) {
            float output;
            --this.burnTime;
            this.currentOutput = output = this.getCurrentOutput();
            this.addEnergy(output);
        }
        if (this.burnTime == 0 && this.isRedstonePowered) {
            this.burnTime = this.totalBurnTime = this.getItemBurnTime(this.func_70301_a(0));
            if (this.burnTime > 0) {
                this.func_70299_a(0, Utils.consumeItem(this.func_70301_a(0)));
            }
        }
    }

    @Override
    public int getScaledBurnTime(int i) {
        return (int)((float)this.burnTime / (float)this.totalBurnTime * (float)i);
    }

    private int getItemBurnTime(ItemStack itemstack) {
        if (itemstack == null) {
            return 0;
        }
        return TileEntityFurnace.func_70398_a((ItemStack)itemstack);
    }

    @Override
    public void func_70307_a(NBTTagCompound data) {
        super.func_70307_a(data);
        this.burnTime = data.func_74762_e("burnTime");
        this.totalBurnTime = data.func_74762_e("totalBurnTime");
    }

    @Override
    public void func_70310_b(NBTTagCompound data) {
        super.func_70310_b(data);
        data.func_74768_a("burnTime", this.burnTime);
        data.func_74768_a("totalBurnTime", this.totalBurnTime);
    }

    @Override
    public void getGUINetworkData(int id, int value) {
        super.getGUINetworkData(id, value);
        switch (id) {
            case 15: {
                this.burnTime = value;
                break;
            }
            case 16: {
                this.totalBurnTime = value;
            }
        }
    }

    @Override
    public void sendGUINetworkData(ContainerEngine containerEngine, ICrafting iCrafting) {
        super.sendGUINetworkData(containerEngine, iCrafting);
        iCrafting.func_71112_a((Container)containerEngine, 15, this.burnTime);
        iCrafting.func_71112_a((Container)containerEngine, 16, this.totalBurnTime);
    }

    @Override
    public float maxEnergyReceived() {
        return 200.0f;
    }

    @Override
    public float maxEnergyExtracted() {
        return 100.0f;
    }

    @Override
    public float getMaxEnergy() {
        return 1000.0f;
    }

    @Override
    public float getCurrentOutput() {
        float e = 0.375f * this.getMaxEnergy() - this.energy;
        this.esum = Math.min(Math.max(this.esum + e, -13.333332f), 13.333332f);
        return Math.min(Math.max(e * 1.0f + this.esum * 0.05f, 0.33333334f), 1.0f);
    }

    @Override
    public LinkedList<ITrigger> getTriggers() {
        LinkedList<ITrigger> triggers = super.getTriggers();
        triggers.add(BuildCraftCore.triggerEmptyInventory);
        triggers.add(BuildCraftCore.triggerContainsInventory);
        triggers.add(BuildCraftCore.triggerSpaceInventory);
        triggers.add(BuildCraftCore.triggerFullInventory);
        return triggers;
    }
}

