/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.triggers;

import buildcraft.api.gates.ActionManager;
import buildcraft.api.gates.ITriggerParameter;
import buildcraft.core.inventory.InventoryIterator;
import buildcraft.core.inventory.StackHelper;
import buildcraft.core.triggers.BCTrigger;
import java.util.Locale;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;

public class TriggerInventoryLevel
extends BCTrigger {
    public TriggerType type;

    public TriggerInventoryLevel(TriggerType type) {
        super(0, "buildcraft.inventorylevel." + type.name().toLowerCase(Locale.ENGLISH));
        this.type = type;
        ActionManager.triggers.put("buildcraft.filteredBuffer." + type.name().toLowerCase(Locale.ENGLISH), this);
    }

    @Override
    public boolean hasParameter() {
        return true;
    }

    @Override
    public boolean requiresParameter() {
        return true;
    }

    @Override
    public String getDescription() {
        switch (this.type) {
            case BELOW_25: {
                return "Contains < 25%";
            }
            case BELOW_50: {
                return "Contains < 50%";
            }
        }
        return "Contains < 75%";
    }

    @Override
    public boolean isTriggerActive(ForgeDirection side, TileEntity tile, ITriggerParameter parameter) {
        if (parameter == null) {
            return false;
        }
        if (tile instanceof IInventory) {
            ItemStack searchStack = parameter.getItemStack();
            int stackSpace = 0;
            int foundItems = 0;
            for (InventoryIterator.IInvSlot slot : InventoryIterator.getIterable((IInventory)tile, side)) {
                ItemStack stackInSlot;
                if (!slot.canPutStackInSlot(searchStack) || (stackInSlot = slot.getStackInSlot()) != null && !StackHelper.instance().canStacksMerge(stackInSlot, searchStack)) continue;
                ++stackSpace;
                foundItems += stackInSlot == null ? 0 : stackInSlot.field_77994_a;
            }
            if (stackSpace > 0) {
                float percentage = (float)foundItems / ((float)stackSpace * (float)searchStack.func_77976_d());
                switch (this.type) {
                    case BELOW_25: {
                        return percentage < 0.25f;
                    }
                    case BELOW_50: {
                        return percentage < 0.5f;
                    }
                }
                return percentage < 0.75f;
            }
        }
        return false;
    }

    @Override
    public int getIconIndex() {
        switch (this.type) {
            case BELOW_25: {
                return 33;
            }
            case BELOW_50: {
                return 34;
            }
        }
        return 35;
    }

    public static enum TriggerType {
        BELOW_25,
        BELOW_50,
        BELOW_75;

    }
}

