/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core;

import buildcraft.api.core.Position;
import buildcraft.core.BlockIndex;
import buildcraft.core.Box;
import buildcraft.core.EntityEnergyLaser;
import buildcraft.core.blueprints.BptBuilderBase;
import buildcraft.core.blueprints.BptContext;
import buildcraft.core.blueprints.BptSlot;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.BCLog;
import buildcraft.core.utils.BlockUtil;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class EntityRobot
extends Entity
implements IEntityAdditionalSpawnData {
    private Box box;
    private int destX;
    private int destY;
    private int destZ;
    EntityEnergyLaser laser;
    public LinkedList<Action> targets = new LinkedList();
    public static int MAX_TARGETS = 20;
    public int wait = 0;

    public EntityRobot(World world) {
        super(world);
    }

    public EntityRobot(World world, Box box) {
        super(world);
        this.box = box;
        this.init();
    }

    protected void init() {
        this.destX = (int)this.box.centerX();
        this.destY = (int)this.box.centerY();
        this.destZ = (int)this.box.centerZ();
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.func_70012_b(this.destX, this.destY, this.destZ, 0.0f, 0.0f);
        this.laser = new EntityEnergyLaser(this.field_70170_p, new Position(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Position(this.field_70165_t, this.field_70163_u, this.field_70161_v));
        this.field_70170_p.func_72838_d((Entity)this.laser);
    }

    public void writeSpawnData(ByteArrayDataOutput data) {
        if (this.box == null) {
            this.box = new Box();
        }
        data.writeInt(this.box.xMin);
        data.writeInt(this.box.yMin);
        data.writeInt(this.box.zMin);
        data.writeInt(this.box.xMax);
        data.writeInt(this.box.yMax);
        data.writeInt(this.box.zMax);
    }

    public void readSpawnData(ByteArrayDataInput data) {
        this.box = new Box();
        this.box.xMin = data.readInt();
        this.box.yMin = data.readInt();
        this.box.zMin = data.readInt();
        this.box.xMax = data.readInt();
        this.box.yMax = data.readInt();
        this.box.zMax = data.readInt();
        this.init();
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(NBTTagCompound nbttagcompound) {
    }

    protected void func_70014_b(NBTTagCompound nbttagcompound) {
    }

    public void func_70071_h_() {
        this.move();
        this.build();
        this.updateLaser();
    }

    protected void move() {
        BlockIndex newDesination;
        this.func_70107_b(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (this.reachedDesination() && (newDesination = this.getNewDestination()) != null) {
            this.setDestination(newDesination.x, newDesination.y, newDesination.z);
        }
    }

    protected BlockIndex getNewDestination() {
        Box movementBoundary = new Box();
        movementBoundary.initialize(this.box);
        movementBoundary.expand(1);
        Box moveArea = new Box();
        moveArea.initialize(this.destX, this.destY, this.destZ, 1);
        ArrayList<BlockIndex> potentialDestinations = new ArrayList<BlockIndex>();
        for (BlockIndex blockIndex : moveArea.getBlocksInArea()) {
            if (!BlockUtil.isSoftBlock(this.field_70170_p, blockIndex.x, blockIndex.y, blockIndex.z) || !movementBoundary.contains(blockIndex)) continue;
            potentialDestinations.add(blockIndex);
        }
        if (!potentialDestinations.isEmpty()) {
            int i = this.field_70170_p.field_73012_v.nextInt(potentialDestinations.size());
            return (BlockIndex)potentialDestinations.get(i);
        }
        return null;
    }

    protected void setDestination(int x, int y, int z) {
        this.destX = x;
        this.destY = y;
        this.destZ = z;
        this.field_70159_w = ((double)this.destX - this.field_70165_t) / 75.0 * (double)(this.laser.getPowerAverage() / 2.0f + 1.0f);
        this.field_70181_x = ((double)this.destY - this.field_70163_u) / 75.0 * (double)(this.laser.getPowerAverage() / 2.0f + 1.0f);
        this.field_70179_y = ((double)this.destZ - this.field_70161_v) / 75.0 * (double)(this.laser.getPowerAverage() / 2.0f + 1.0f);
    }

    protected boolean reachedDesination() {
        return this.func_70011_f(this.destX, this.destY, this.destZ) <= 0.2;
    }

    protected void build() {
        this.updateWait();
        if (this.targets.size() > 0) {
            Action a = this.targets.getFirst();
            if (a.slot != null) {
                BptSlot target = a.slot;
                if (this.wait <= 0 && BlockUtil.canChangeBlock(this.field_70170_p, target.x, target.y, target.z)) {
                    if (!CoreProxy.proxy.isRenderWorld(this.field_70170_p)) {
                        if (target.mode == BptSlot.Mode.ClearIfInvalid) {
                            if (!target.isValid(a.context)) {
                                this.field_70170_p.func_94571_i(target.x, target.y, target.z);
                            }
                        } else {
                            if (target.stackToUse != null) {
                                this.field_70170_p.func_94571_i(target.x, target.y, target.z);
                                throw new RuntimeException("NOT IMPLEMENTED");
                            }
                            try {
                                target.buildBlock(a.context);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                                BCLog.logger.throwing("EntityRobot", "update", t);
                            }
                        }
                    }
                    this.targets.pop();
                }
            } else if (a.builder != null) {
                a.builder.postProcessing(this.field_70170_p);
                this.targets.pop();
            }
        }
    }

    public void updateWait() {
        if (this.targets.size() > 0) {
            this.wait = this.wait == 0 ? MAX_TARGETS - this.targets.size() + 2 : --this.wait;
        }
    }

    private void updateLaser() {
        if (this.laser == null) {
            return;
        }
        if (this.targets.size() > 0) {
            Action a = this.targets.getFirst();
            BptSlot target = a.slot;
            if (target != null) {
                this.laser.setPositions(new Position(this.field_70165_t, this.field_70163_u, this.field_70161_v), new Position((double)target.x + 0.5, (double)target.y + 0.5, (double)target.z + 0.5));
                this.laser.show();
            }
        } else {
            this.laser.hide();
        }
        this.laser.pushPower((float)this.targets.size() / (float)MAX_TARGETS * 4.0f);
    }

    public void scheduleContruction(BptSlot slot, BptContext context) {
        if (slot != null) {
            this.targets.add(new Action(slot, context));
        }
    }

    public void markEndOfBlueprint(BptBuilderBase builder) {
        this.targets.add(new Action(builder));
    }

    public boolean readyToBuild() {
        return this.targets.size() < MAX_TARGETS;
    }

    public boolean done() {
        return this.targets.isEmpty();
    }

    public void setBox(Box box) {
        this.box = box;
        this.setDestination((int)box.centerX(), (int)box.centerY(), (int)box.centerZ());
    }

    public void func_70106_y() {
        if (this.laser != null) {
            this.laser.func_70106_y();
        }
        super.func_70106_y();
    }

    private class Action {
        BptSlot slot;
        BptBuilderBase builder;
        BptContext context;

        public Action(BptSlot slot, BptContext context) {
            this.slot = slot;
            this.context = context;
        }

        public Action(BptBuilderBase builder) {
            this.builder = builder;
        }
    }
}

