/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.ColourModifier;
import codechicken.lib.render.ColourMultiplier;
import codechicken.lib.render.IUVTransformation;
import codechicken.lib.render.IVertexModifier;
import codechicken.lib.render.IconTransformation;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.render.UVTranslation;
import codechicken.lib.render.Vertex5;
import codechicken.lib.vec.AxisCycle;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IMicroMaterialRender;
import codechicken.microblock.JMicroblockClient;
import codechicken.microblock.MicroMaterialRegistry;
import mrtjp.projectred.transmission.FramedWirePart;
import mrtjp.projectred.transmission.RenderWire;
import org.lwjgl.opengl.GL11;

public class RenderFramedWire {
    public static CCModel[] frameModels = new CCModel[7];
    public static CCModel[] wireModels = new CCModel[192];
    public static JacketedModel[] jacketModels = new JacketedModel[192];
    private static WireModelGenerator gen_inst = new WireModelGenerator();
    private static LazyLightMatrix dynamicLight = new LazyLightMatrix();

    public static void reverseOrder(Vertex5[] vertex5Array) {
        for (int i = 0; i < vertex5Array.length; i += 4) {
            Vertex5 vertex5 = vertex5Array[i + 1];
            vertex5Array[i + 1] = vertex5Array[i + 3];
            vertex5Array[i + 3] = vertex5;
        }
    }

    public static int modelKey(int n, int n2) {
        return n2 | n << 6;
    }

    public static int modelKey(FramedWirePart framedWirePart) {
        return RenderFramedWire.modelKey(framedWirePart.getThickness(), framedWirePart.connMap);
    }

    public static CCModel getOrGenerateWireModel(int n) {
        CCModel cCModel = wireModels[n];
        if (cCModel == null) {
            RenderFramedWire.wireModels[n] = cCModel = gen_inst.generateWireModel(n);
        }
        return cCModel;
    }

    public static JacketedModel getOrGenerateJacketedModel(int n) {
        JacketedModel jacketedModel = jacketModels[n];
        if (jacketedModel == null) {
            RenderFramedWire.jacketModels[n] = jacketedModel = gen_inst.generateJacketedModel(n);
        }
        return jacketedModel;
    }

    public static void render(FramedWirePart framedWirePart, Vector3 vector3) {
        dynamicLight.setPos((acf)framedWirePart.world(), framedWirePart.x(), framedWirePart.y(), framedWirePart.z());
        RenderFramedWire.render(framedWirePart, vector3, dynamicLight);
    }

    public static void render(FramedWirePart framedWirePart, Vector3 vector3, LazyLightMatrix lazyLightMatrix) {
        ColourModifier colourModifier;
        int n = RenderFramedWire.modelKey(framedWirePart);
        IconTransformation iconTransformation = new IconTransformation(framedWirePart.getIcon());
        Object object = colourModifier = framedWirePart.getColour() == -1 ? ColourModifier.instance : new ColourMultiplier(framedWirePart.getColour());
        if (framedWirePart.material == 0) {
            Translation translation = new Translation(vector3);
            RenderFramedWire.getOrGenerateWireModel(n).render((Transformation)translation, (IUVTransformation)iconTransformation, (IVertexModifier)colourModifier);
            RenderFramedWire.renderWireFrame(n, (Transformation)translation, (IUVTransformation)iconTransformation);
        } else {
            RenderFramedWire.getOrGenerateJacketedModel(n).render(framedWirePart, vector3, lazyLightMatrix, (IUVTransformation)iconTransformation, (IVertexModifier)colourModifier, framedWirePart.material);
        }
    }

    private static void renderWireFrame(int n, Transformation transformation, IUVTransformation iUVTransformation) {
        frameModels[6].render(transformation, iUVTransformation);
        for (int i = 0; i < 6; ++i) {
            if ((n & 1 << i) == 0) continue;
            frameModels[i].render(transformation, iUVTransformation);
        }
    }

    public static void renderBreakingOverlay(ms ms2, FramedWirePart framedWirePart) {
        for (Cuboid6 cuboid6 : framedWirePart.getCollisionBoxes()) {
            RenderUtils.renderBlock((Cuboid6)cuboid6, (int)0, (Transformation)new Translation((double)framedWirePart.x(), (double)framedWirePart.y(), (double)framedWirePart.z()), (IUVTransformation)new IconTransformation(ms2), null);
        }
    }

    public static void renderInv(int n, Transformation transformation, ms ms2) {
        IconTransformation iconTransformation = new IconTransformation(ms2);
        RenderFramedWire.getOrGenerateWireModel(RenderFramedWire.modelKey(n, 63)).render(transformation, (IUVTransformation)iconTransformation);
        CCRenderState.setColour((int)-1);
        RenderFramedWire.renderWireFrame(RenderFramedWire.modelKey(n, 0), transformation, (IUVTransformation)iconTransformation);
    }

    public static void renderCoverHighlight(FramedWirePart framedWirePart, int n) {
        BlockCoord blockCoord = new BlockCoord((asp)framedWirePart.tile());
        GL11.glPushMatrix();
        GL11.glTranslated((double)((double)blockCoord.x + 0.5), (double)((double)blockCoord.y + 0.5), (double)((double)blockCoord.z + 0.5));
        GL11.glScaled((double)1.002, (double)1.002, (double)1.002);
        GL11.glTranslated((double)-0.5, (double)-0.5, (double)-0.5);
        GL11.glEnable((int)3042);
        GL11.glDepthMask((boolean)false);
        GL11.glBlendFunc((int)770, (int)771);
        CCRenderState.reset();
        TextureUtils.bindAtlas((int)0);
        CCRenderState.useNormals((boolean)true);
        CCRenderState.setBrightness((acf)framedWirePart.world(), (int)blockCoord.x, (int)blockCoord.y, (int)blockCoord.z);
        CCRenderState.setAlpha((int)127);
        CCRenderState.useModelColours((boolean)true);
        CCRenderState.startDrawing((int)7);
        RenderFramedWire.getOrGenerateJacketedModel(RenderFramedWire.modelKey(framedWirePart)).renderCovers(framedWirePart.world(), new BlockCoord(), new Vector3(), null, n);
        CCRenderState.draw();
        GL11.glDisable((int)3042);
        GL11.glDepthMask((boolean)true);
        GL11.glPopMatrix();
    }

    static {
        WireFrameModelGenerator.generateModels();
    }

    private static class WireModelGenerator {
        int connMap;
        int tw;
        double w;
        int connCount;
        int i;
        CCModel model;
        private IUVTransformation uvReflect = new RenderWire.UVT(new Scale(-1.0, 1.0, 1.0).at(new Vector3(8.0, 0.0, 16.0)));

        private WireModelGenerator() {
        }

        public static int countConnections(int n) {
            int n2 = 0;
            for (int i = 0; i < 6; ++i) {
                if ((n & 1 << i) == 0) continue;
                ++n2;
            }
            return n2;
        }

        private void setup(int n) {
            this.connMap = n & 0x3F;
            this.connCount = WireModelGenerator.countConnections(this.connMap);
            int n2 = n >> 6;
            this.tw = n2 + 1;
            this.w = (double)this.tw / 16.0 + 0.004;
            this.i = 0;
        }

        public CCModel generateWireModel(int n) {
            this.setup(n);
            this.model = CCModel.quadModel((int)(this.connCount * 16 + 24));
            for (int i = 0; i < 6; ++i) {
                this.generateSide(i);
            }
            return RenderWire.finishModel(this.model);
        }

        private void generateSide(int n) {
            Vertex5[] vertex5Array = this.connCount == 0 ? this.generateStub(n) : (this.connCount == 1 ? ((this.connMap & 1 << (n ^ 1)) != 0 ? this.generateStub(n) : this.generateSideFromType(n)) : this.generateSideFromType(n));
            Transformation transformation = AxisCycle.cycles[n / 2].at(Vector3.center);
            for (Vertex5 vertex5 : vertex5Array) {
                vertex5.apply(transformation);
            }
            this.i = RenderWire.addVerts(this.model, vertex5Array, this.i);
        }

        private Vertex5[] generateSideFromType(int n) {
            if ((this.connMap & 1 << n) != 0) {
                return this.generateStraight(n);
            }
            return this.generateFlat(n);
        }

        private Vertex5[] generateStraight(int n) {
            Vertex5[] vertex5Array = new Vertex5[20];
            System.arraycopy(this.faceVerts(n, 0.0), 0, vertex5Array, 0, 4);
            if (n % 2 == 0) {
                vertex5Array[4] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, (double)(8 - this.tw), 24.0);
                vertex5Array[5] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, (double)(8 + this.tw), 24.0);
                vertex5Array[6] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, (double)(8 + this.tw), (double)(16 + this.tw));
                vertex5Array[7] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, (double)(8 - this.tw), (double)(16 + this.tw));
            } else {
                vertex5Array[4] = new Vertex5(0.5 - this.w, 0.5 + this.w, 0.5 + this.w, (double)(8 - this.tw), (double)(16 - this.tw));
                vertex5Array[5] = new Vertex5(0.5 + this.w, 0.5 + this.w, 0.5 + this.w, (double)(8 + this.tw), (double)(16 - this.tw));
                vertex5Array[6] = new Vertex5(0.5 + this.w, 1.0, 0.5 + this.w, (double)(8 + this.tw), 8.0);
                vertex5Array[7] = new Vertex5(0.5 - this.w, 1.0, 0.5 + this.w, (double)(8 - this.tw), 8.0);
            }
            for (int i = 1; i < 4; ++i) {
                Transformation transformation = Rotation.quarterRotations[i].at(Vector3.center);
                for (int j = 0; j < 4; ++j) {
                    vertex5Array[j + i * 4 + 4] = vertex5Array[j + 4].copy().apply(transformation);
                    if (i < 2) continue;
                    vertex5Array[j + i * 4 + 4].apply(this.uvReflect);
                }
            }
            UVTranslation uVTranslation = new UVTranslation(12.0, 12.0);
            for (int i = 0; i < 4; ++i) {
                vertex5Array[i].apply((IUVTransformation)uVTranslation);
            }
            return vertex5Array;
        }

        private Vertex5[] generateFlat(int n) {
            RenderWire.UVT uVT;
            int n2;
            Vertex5[] vertex5Array = this.faceVerts(n, 0.5 - this.w);
            int n3 = 0;
            for (n2 = 0; n2 < 4; ++n2) {
                int n4 = ((n & 6) + n2 + 2) % 6;
                if ((this.connMap & 1 << n4) == 0) continue;
                n3 |= 1 << n2;
            }
            n2 = (n3 & 0xC) == 0 ? 0 : ((n3 & 3) == 0 ? 1 : 2);
            if (n2 == 1) {
                uVT = new RenderWire.UVT(Rotation.quarterRotations[1].at(new Vector3(8.0, 0.0, 16.0)));
            } else if (n2 == 2) {
                uVT = new RenderWire.UVT((Transformation)Rotation.quarterRotations[1].at(new Vector3(8.0, 0.0, 16.0)).with((Transformation)new Translation(16.0, 0.0, 0.0)));
            } else {
                return vertex5Array;
            }
            for (Vertex5 vertex5 : vertex5Array) {
                vertex5.apply((IUVTransformation)uVT);
            }
            return vertex5Array;
        }

        private Vertex5[] generateStub(int n) {
            Vertex5[] vertex5Array = this.faceVerts(n, 0.5 - this.w);
            UVTranslation uVTranslation = new UVTranslation(12.0, 12.0);
            for (Vertex5 vertex5 : vertex5Array) {
                vertex5.apply((IUVTransformation)uVTranslation);
            }
            return vertex5Array;
        }

        private Vertex5[] faceVerts(int n, double d) {
            Vertex5[] vertex5Array = new Vertex5[]{new Vertex5(0.5 - this.w, d, 0.5 - this.w, (double)(8 - this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, d, 0.5 - this.w, (double)(8 + this.tw), (double)(16 + this.tw)), new Vertex5(0.5 + this.w, d, 0.5 + this.w, (double)(8 + this.tw), (double)(16 - this.tw)), new Vertex5(0.5 - this.w, d, 0.5 + this.w, (double)(8 - this.tw), (double)(16 - this.tw))};
            if (n % 2 == 1) {
                Transformation transformation = new Scale(1.0, -1.0, 1.0).at(Vector3.center);
                for (Vertex5 vertex5 : vertex5Array) {
                    vertex5.apply(transformation);
                }
                RenderFramedWire.reverseOrder(vertex5Array);
            }
            return vertex5Array;
        }

        public JacketedModel generateJacketedModel(int n) {
            this.setup(n);
            return new JacketedModel(this.generateJacketedWireModel(), this.generateJacketedBoxes());
        }

        private IndexedCuboid6[] generateJacketedBoxes() {
            if (this.connCount == 0) {
                return new IndexedCuboid6[]{new IndexedCuboid6((Object)0, FramedWirePart.boundingBoxes[6])};
            }
            int n = 0;
            for (int i = 0; i < 3; ++i) {
                if ((this.connMap & 3 << i * 2) == 0) continue;
                ++n;
            }
            IndexedCuboid6[] indexedCuboid6Array = new IndexedCuboid6[n];
            this.i = 0;
            boolean bl = true;
            for (int i = 0; i < 3; ++i) {
                bl = !this.generateAxialJacketBoxes(i, bl, indexedCuboid6Array);
            }
            return indexedCuboid6Array;
        }

        private boolean generateAxialJacketBoxes(int n, boolean bl, IndexedCuboid6[] indexedCuboid6Array) {
            Cuboid6 cuboid6;
            int n2 = this.connMap >> n * 2 & 3;
            if (n2 == 0) {
                return false;
            }
            if (n2 == 1) {
                cuboid6 = FramedWirePart.boundingBoxes[0].copy();
            } else if (n2 == 2) {
                cuboid6 = FramedWirePart.boundingBoxes[1].copy();
            } else {
                cuboid6 = FramedWirePart.boundingBoxes[0].copy();
                cuboid6.max.y = 1.0;
            }
            cuboid6.apply(Rotation.sideRotations[n * 2].at(Vector3.center));
            if (bl) {
                cuboid6.enclose(FramedWirePart.boundingBoxes[6]);
            }
            int n3 = bl || n2 == 3 ? 0 : (n2 == 1 ? 1 << 2 * n + 1 : 1 << 2 * n);
            indexedCuboid6Array[this.i] = new IndexedCuboid6((Object)n3, cuboid6);
            ++this.i;
            return true;
        }

        private CCModel generateJacketedWireModel() {
            int n = this.connCount == 0 ? 6 : (this.connCount == 1 ? 2 : this.connCount);
            this.model = CCModel.quadModel((int)(n * 4));
            for (int i = 0; i < 6; ++i) {
                this.generateJacketedSide(i);
            }
            return RenderWire.finishModel(this.model);
        }

        private void generateJacketedSide(int n) {
            double d;
            if ((this.connMap & 1 << n) != 0) {
                d = 0.0;
            } else if (this.connCount == 0) {
                d = 0.25;
            } else if (this.connCount == 1 && (this.connMap & 1 << (n ^ 1)) != 0) {
                d = 0.25;
            } else {
                return;
            }
            Vertex5[] vertex5Array = this.faceVerts(n, d - 0.002);
            Transformation transformation = AxisCycle.cycles[n / 2].at(Vector3.center);
            UVTranslation uVTranslation = new UVTranslation(12.0, 12.0);
            for (Vertex5 vertex5 : vertex5Array) {
                vertex5.apply(transformation);
                vertex5.apply((IUVTransformation)uVTranslation);
            }
            this.i = RenderWire.addVerts(this.model, vertex5Array, this.i);
        }
    }

    private static class JacketedModel
    implements IMicroMaterialRender {
        public CCModel wireModel;
        public IndexedCuboid6[] boxes;
        public Cuboid6 bounds;
        private abw world;
        private BlockCoord pos = new BlockCoord();

        public JacketedModel(CCModel cCModel, IndexedCuboid6[] indexedCuboid6Array) {
            this.wireModel = cCModel;
            this.boxes = indexedCuboid6Array;
            this.bounds = indexedCuboid6Array[0].copy();
            for (int i = 1; i < indexedCuboid6Array.length; ++i) {
                this.bounds.enclose((Cuboid6)indexedCuboid6Array[i]);
            }
        }

        public void render(FramedWirePart framedWirePart, Vector3 vector3, LazyLightMatrix lazyLightMatrix, IUVTransformation iUVTransformation, IVertexModifier iVertexModifier, int n) {
            this.renderCovers(framedWirePart.world(), new BlockCoord((asp)framedWirePart.tile()), vector3, lazyLightMatrix, n);
            this.wireModel.render((Transformation)new Translation(vector3), iUVTransformation, iVertexModifier);
        }

        public void renderCovers(abw abw2, BlockCoord blockCoord, Vector3 vector3, LazyLightMatrix lazyLightMatrix, int n) {
            this.world = abw2;
            this.pos.set(blockCoord);
            MicroMaterialRegistry.IMicroMaterial iMicroMaterial = MicroMaterialRegistry.getMaterial((int)n);
            for (IndexedCuboid6 indexedCuboid6 : this.boxes) {
                JMicroblockClient.renderCuboid((Vector3)vector3, (LazyLightMatrix)lazyLightMatrix, (MicroMaterialRegistry.IMicroMaterial)iMicroMaterial, (Cuboid6)indexedCuboid6, (int)((Integer)indexedCuboid6.data), (IMicroMaterialRender)this);
            }
        }

        public Cuboid6 getRenderBounds() {
            return this.bounds;
        }

        public int x() {
            return this.pos.x;
        }

        public int y() {
            return this.pos.y;
        }

        public int z() {
            return this.pos.z;
        }

        public abw world() {
            return this.world;
        }
    }

    private static class WireFrameModelGenerator {
        double w = 0.25;
        double d = 0.0605;

        private WireFrameModelGenerator() {
        }

        public static void generateModels() {
            WireFrameModelGenerator wireFrameModelGenerator = new WireFrameModelGenerator();
            wireFrameModelGenerator.generateCenterModel();
            wireFrameModelGenerator.generateSideModels();
            wireFrameModelGenerator.finishModels();
        }

        public void generateCenterModel() {
            CCModel cCModel = CCModel.quadModel((int)48);
            cCModel.verts[0] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 - this.w, 20.0, 8.0);
            cCModel.verts[1] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 - this.w, 28.0, 8.0);
            cCModel.verts[2] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, 28.0, 0.0);
            cCModel.verts[3] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, 20.0, 0.0);
            cCModel.verts[4] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 + this.w, 20.0, 8.0);
            cCModel.verts[5] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 + this.w, 28.0, 8.0);
            cCModel.verts[6] = new Vertex5(0.5 + this.w, 0.5 - this.w + this.d, 0.5 - this.w, 28.0, 0.0);
            cCModel.verts[7] = new Vertex5(0.5 - this.w, 0.5 - this.w + this.d, 0.5 - this.w, 20.0, 0.0);
            cCModel.generateSidedParts(0, Vector3.center);
            RenderFramedWire.frameModels[6] = cCModel;
        }

        public void generateSideModels() {
            int n;
            CCModel cCModel = CCModel.quadModel((int)36);
            cCModel.verts[0] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 16.0, 0.0);
            cCModel.verts[1] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 16.0, 8.0);
            cCModel.verts[2] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w, 20.0, 8.0);
            cCModel.verts[3] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w, 20.0, 0.0);
            cCModel.verts[4] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w - this.d, 16.0, 0.0);
            cCModel.verts[5] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w - this.d, 16.0, 8.0);
            cCModel.verts[6] = new Vertex5(0.5 - this.w, 0.5 - this.w, 0.5 + this.w - this.d, 20.0, 8.0);
            cCModel.verts[7] = new Vertex5(0.5 + this.w, 0.5 - this.w, 0.5 + this.w - this.d, 20.0, 0.0);
            for (n = 1; n < 4; ++n) {
                cCModel.apply(Rotation.quarterRotations[n].at(Vector3.center), 0, n * 8, 8);
            }
            cCModel.verts[32] = new Vertex5(0.5 - this.w, 0.0, 0.5 - this.w, 24.0, 32.0);
            cCModel.verts[33] = new Vertex5(0.5 + this.w, 0.0, 0.5 - this.w, 32.0, 32.0);
            cCModel.verts[34] = new Vertex5(0.5 + this.w, 0.0, 0.5 + this.w, 32.0, 24.0);
            cCModel.verts[35] = new Vertex5(0.5 - this.w, 0.0, 0.5 + this.w, 24.0, 24.0);
            RenderFramedWire.frameModels[0] = cCModel;
            for (n = 1; n < 6; ++n) {
                RenderFramedWire.frameModels[n] = cCModel.copy().apply(Rotation.sideRotations[n].at(Vector3.center));
                if (n % 2 != 1) continue;
                Vertex5[] vertex5Array = RenderFramedWire.frameModels[n].verts;
                RenderWire.UVT uVT = new RenderWire.UVT(Rotation.quarterRotations[2].at(new Vector3(24.0, 0.0, 4.0)));
                for (int i = 0; i < 32; ++i) {
                    vertex5Array[i].apply((IUVTransformation)uVT);
                }
            }
        }

        public void finishModels() {
            for (CCModel cCModel : frameModels) {
                RenderWire.finishModel(cCModel);
            }
        }
    }
}

