/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.lighting.LazyLightMatrix;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.TextureUtils;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.IHollowConnect;
import codechicken.microblock.ItemMicroPart;
import codechicken.microblock.MicroMaterialRegistry;
import codechicken.microblock.handler.MicroblockProxy;
import codechicken.multipart.JNormalOcclusion;
import codechicken.multipart.NormalOcclusionTest;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TSlottedPart;
import codechicken.multipart.TileMultipart;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Arrays;
import java.util.LinkedList;
import mrtjp.projectred.ProjectRedCore;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.BasicUtils;
import mrtjp.projectred.core.Configurator;
import mrtjp.projectred.transmission.IWirePart;
import mrtjp.projectred.transmission.RenderFramedWire;
import mrtjp.projectred.transmission.WireDef;
import mrtjp.projectred.transmission.WirePart;
import mrtjp.projectred.transmission.WirePropogator;
import org.lwjgl.opengl.GL11;

public abstract class FramedWirePart
extends TMultiPart
implements IConnectable,
TSlottedPart,
JNormalOcclusion,
IWirePart,
IHollowConnect {
    public static Cuboid6[] boundingBoxes = new Cuboid6[7];
    private static int expandBounds = -1;
    public int connMap;
    public int material = 0;

    public void preparePlacement(int n) {
    }

    public void save(by by2) {
        super.save(by2);
        by2.a("connMap", this.connMap);
        by2.a("mat", MicroMaterialRegistry.materialName((int)this.material));
    }

    public void load(by by2) {
        super.load(by2);
        this.connMap = by2.e("connMap");
        this.material = MicroMaterialRegistry.materialID((String)by2.i("mat"));
    }

    public void writeDesc(MCDataOutput mCDataOutput) {
        mCDataOutput.writeByte(this.clientConnMap());
        MicroMaterialRegistry.writePartID((MCDataOutput)mCDataOutput, (int)this.material);
    }

    public void readDesc(MCDataInput mCDataInput) {
        this.connMap = mCDataInput.readUByte();
        this.material = MicroMaterialRegistry.readPartID((MCDataInput)mCDataInput);
    }

    public void read(MCDataInput mCDataInput) {
        this.read(mCDataInput, mCDataInput.readUByte());
    }

    public void read(MCDataInput mCDataInput, int n) {
        if (n == 0) {
            this.connMap = mCDataInput.readUByte();
            if (this.useStaticRenderer()) {
                this.tile().markRender();
            }
        } else if (n == 1) {
            this.material = MicroMaterialRegistry.readPartID((MCDataInput)mCDataInput);
            if (this.useStaticRenderer()) {
                this.tile().markRender();
            }
        }
    }

    public void onPartChanged(TMultiPart tMultiPart) {
        if (!this.world().I) {
            WirePropogator.logCalculation();
            boolean bl = this.updateInternalConnections();
            if (this.updateOpenConnections()) {
                bl |= this.updateExternalConnections();
            }
            if (bl) {
                this.sendConnUpdate();
                WirePropogator.propogateTo(this, 2);
            } else {
                WirePropogator.propogateTo(this, 0);
            }
        }
    }

    public void onNeighborChanged() {
        if (!this.world().I) {
            WirePropogator.logCalculation();
            if (this.updateExternalConnections()) {
                this.sendConnUpdate();
                WirePropogator.propogateTo(this, 2);
            } else {
                WirePropogator.propogateTo(this, 0);
            }
        }
    }

    public void onAdded() {
        if (!this.world().I) {
            this.updateOpenConnections();
            boolean bl = this.updateInternalConnections();
            if (bl |= this.updateExternalConnections()) {
                this.sendConnUpdate();
                WirePropogator.propogateTo(this, 0);
            }
        }
    }

    public void onRemoved() {
        super.onRemoved();
        if (!this.world().I) {
            for (int i = 0; i < 6; ++i) {
                if ((this.connMap & 1 << i) == 0) continue;
                this.notifyStraightChange(i);
            }
        }
    }

    public void onChunkLoad() {
        if ((this.connMap & Integer.MIN_VALUE) != 0) {
            this.connMap = 0;
            this.updateInternalConnections();
            if (this.updateOpenConnections()) {
                this.updateExternalConnections();
            }
            this.tile().markDirty();
        }
    }

    public void onWorldJoin() {
        this.onNeighborChanged();
    }

    public int clientConnMap() {
        return this.connMap & 0x3F | this.connMap >> 6 & 0x3F;
    }

    public void sendConnUpdate() {
        this.tile().getWriteStream((TMultiPart)this).writeByte(0).writeByte(this.clientConnMap());
    }

    public void sendMatUpdate() {
        MicroMaterialRegistry.writePartID((MCDataOutput)this.tile().getWriteStream((TMultiPart)this).writeByte(1), (int)this.material);
    }

    protected boolean updateExternalConnections() {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.maskOpen(i) || !this.connectStraight(i)) continue;
            n |= 1 << i;
        }
        if (n != (this.connMap & 0x3F)) {
            this.connMap = this.connMap & 0xFFFFFFC0 | n;
            return true;
        }
        return false;
    }

    protected boolean updateInternalConnections() {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.connectInternal(i)) continue;
            n |= 1 << i + 6;
        }
        if (n != (this.connMap & 0xFC0)) {
            this.connMap = this.connMap & 0xFFFFF03F | n;
            return true;
        }
        return false;
    }

    protected boolean updateOpenConnections() {
        int n = 0;
        for (int i = 0; i < 6; ++i) {
            if (!this.connectionOpen(i)) continue;
            n |= 1 << i + 12;
        }
        if (n != (this.connMap & 0x3F000)) {
            this.connMap = this.connMap & 0xFFFC0FFF | n;
            return true;
        }
        return false;
    }

    public boolean connectionOpen(int n) {
        TMultiPart tMultiPart = this.tile().partMap(n);
        if (tMultiPart == null) {
            return true;
        }
        if (tMultiPart instanceof WirePart && this.canConnectToType((WirePart)tMultiPart)) {
            return false;
        }
        expandBounds = n;
        boolean bl = this.tile().canReplacePart((TMultiPart)this, (TMultiPart)this);
        expandBounds = -1;
        return bl;
    }

    public boolean connectStraight(int n) {
        TMultiPart tMultiPart;
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null && (tMultiPart = tileMultipart.partMap(6)) instanceof IConnectable) {
            return ((IConnectable)tMultiPart).connectStraight((IConnectable)this, n ^ 1, -1);
        }
        return this.connectStraightOverride(n);
    }

    public boolean connectStraightOverride(int n) {
        return false;
    }

    public boolean connectInternal(int n) {
        TMultiPart tMultiPart = this.tile().partMap(n);
        if (tMultiPart instanceof IConnectable) {
            return ((IConnectable)tMultiPart).connectInternal((IConnectable)this, -1);
        }
        return this.connectInternalOverride(tMultiPart, n);
    }

    public boolean connectInternalOverride(TMultiPart tMultiPart, int n) {
        return false;
    }

    public boolean connectStraight(IConnectable iConnectable, int n, int n2) {
        if (this.canConnectToType(iConnectable) && this.maskOpen(n)) {
            int n3 = this.connMap;
            this.connMap |= 1 << n;
            if (n3 != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean connectInternal(IConnectable iConnectable, int n) {
        if (this.canConnectToType(iConnectable)) {
            int n2 = this.connMap;
            this.connMap |= 1 << n + 6;
            if (n2 != this.connMap) {
                this.sendConnUpdate();
            }
            return true;
        }
        return false;
    }

    public boolean connectCorner(IConnectable iConnectable, int n, int n2) {
        return false;
    }

    public boolean canConnectCorner(int n) {
        return false;
    }

    public abstract boolean canConnectToType(IConnectable var1);

    public void notifyStraightChange(int n) {
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n);
        this.world().g(blockCoord.x, blockCoord.y, blockCoord.z, this.tile().q().cF);
    }

    public boolean maskConnects(int n) {
        return (this.connMap & 65 << n) != 0;
    }

    public boolean maskOpen(int n) {
        return (this.connMap & 4096 << n) != 0;
    }

    public void propogate(TMultiPart tMultiPart, int n) {
        if (n != 3) {
            WirePropogator.addPartChange(this);
        }
        for (int i = 0; i < 6; ++i) {
            if ((this.connMap & 1 << i) != 0) {
                this.propogateStraight(i, tMultiPart, n);
                continue;
            }
            if ((this.connMap & 1 << i + 6) == 0) continue;
            this.propogateInternal(i, tMultiPart, n);
        }
        this.propogateOther(n);
    }

    public void propogateStraight(int n, TMultiPart tMultiPart, int n2) {
        BlockCoord blockCoord = new BlockCoord((asp)this.tile()).offset(n);
        TileMultipart tileMultipart = BasicUtils.getMultipartTile((acf)this.world(), (BlockCoord)blockCoord);
        if (tileMultipart != null) {
            TMultiPart tMultiPart2 = tileMultipart.partMap(6);
            if (tMultiPart2 == tMultiPart) {
                return;
            }
            if (this.propogateTo(tMultiPart2, n2)) {
                return;
            }
        }
        WirePropogator.addNeighborChange(blockCoord);
    }

    public void propogateInternal(int n, TMultiPart tMultiPart, int n2) {
        TMultiPart tMultiPart2 = this.tile().partMap(n);
        if (tMultiPart2 == tMultiPart) {
            return;
        }
        this.propogateTo(tMultiPart2, n2);
    }

    public void propogateOther(int n) {
    }

    public boolean propogateTo(TMultiPart tMultiPart, int n) {
        if (tMultiPart instanceof IWirePart) {
            WirePropogator.propogateTo((IWirePart)tMultiPart, this, n);
            return true;
        }
        return false;
    }

    @Override
    public void onSignalUpdate() {
        this.tile().markDirty();
    }

    @Override
    public boolean isWireSide(int n) {
        return true;
    }

    public abstract WireDef getWireType();

    public int getThickness() {
        return this.getWireType().thickness();
    }

    public String getType() {
        return this.getWireType().framedType();
    }

    public float getStrength(ata ata2, uf uf2) {
        if (this.material > 0) {
            return Math.min(4.0f, MicroMaterialRegistry.getMaterial((int)this.material).getStrength(uf2));
        }
        return 4.0f;
    }

    public ye getItem() {
        return this.getWireType().getFramedItemStack();
    }

    public Iterable<ye> getDrops() {
        LinkedList<ye> linkedList = new LinkedList<ye>();
        linkedList.add(this.getItem());
        if (this.material != 0) {
            linkedList.add(ItemMicroPart.create((int)1, (int)this.material));
        }
        return linkedList;
    }

    public ye pickItem(ata ata2) {
        return this.getItem();
    }

    public int getSlotMask() {
        return 64;
    }

    public Iterable<IndexedCuboid6> getSubParts() {
        Iterable<Cuboid6> iterable = this.getCollisionBoxes();
        LinkedList<IndexedCuboid6> linkedList = new LinkedList<IndexedCuboid6>();
        for (Cuboid6 cuboid6 : iterable) {
            linkedList.add(new IndexedCuboid6((Object)0, cuboid6));
        }
        return linkedList;
    }

    public boolean occlusionTest(TMultiPart tMultiPart) {
        return NormalOcclusionTest.apply((JNormalOcclusion)this, (TMultiPart)tMultiPart);
    }

    public Iterable<Cuboid6> getOcclusionBoxes() {
        if (expandBounds >= 0) {
            return Arrays.asList(boundingBoxes[expandBounds]);
        }
        return Arrays.asList(boundingBoxes[6]);
    }

    public Iterable<Cuboid6> getCollisionBoxes() {
        LinkedList<Cuboid6> linkedList = new LinkedList<Cuboid6>();
        linkedList.add(boundingBoxes[6]);
        for (int i = 0; i < 6; ++i) {
            if (!this.maskConnects(i)) continue;
            linkedList.add(boundingBoxes[i]);
        }
        return linkedList;
    }

    @SideOnly(value=Side.CLIENT)
    public ms getIcon() {
        return this.getWireType().wireSprites()[0];
    }

    public int getColour() {
        return -1;
    }

    public boolean useStaticRenderer() {
        return Configurator.staticWires;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderStatic(Vector3 vector3, LazyLightMatrix lazyLightMatrix, int n) {
        if (n == 0 && this.useStaticRenderer()) {
            CCRenderState.setBrightness((acf)this.world(), (int)this.x(), (int)this.y(), (int)this.z());
            RenderFramedWire.render(this, vector3, lazyLightMatrix);
            CCRenderState.setColour((int)-1);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(Vector3 vector3, float f, int n) {
        if (n == 0 && !this.useStaticRenderer()) {
            GL11.glDisable((int)2896);
            TextureUtils.bindAtlas((int)0);
            CCRenderState.useModelColours((boolean)true);
            CCRenderState.startDrawing((int)7);
            RenderFramedWire.render(this, vector3);
            CCRenderState.draw();
            CCRenderState.setColour((int)-1);
            GL11.glEnable((int)2896);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawBreaking(bfr bfr2) {
        CCRenderState.reset();
        RenderFramedWire.renderBreakingOverlay(bfr2.d, this);
    }

    public boolean doesTick() {
        return false;
    }

    public int getHollowSize() {
        return 8;
    }

    public void dropMaterial(uf uf2) {
        if (this.material > 0 && !uf2.bG.d) {
            ye ye2 = ItemMicroPart.create((int)1, (int)this.material);
            BasicUtils.dropItemFromLocation((abw)this.world(), (ye)ye2, (boolean)false, (uf)uf2, (int)-1, (int)0, (BlockCoord)new BlockCoord((asp)this.tile()));
        }
    }

    protected abstract boolean test(uf var1);

    public boolean activate(uf uf2, ata ata2, ye ye2) {
        ye ye3 = uf2.aZ();
        if (ye3 == null) {
            if (uf2.ah() && this.material > 0 && !this.world().I) {
                this.dropMaterial(uf2);
                this.material = 0;
                this.sendMatUpdate();
            }
            return false;
        }
        if (ye3.b() == MicroblockProxy.itemMicro() && ye3.k() == 1 && ItemMicroPart.getMaterialID((ye)ye3) != this.material) {
            if (!this.world().I) {
                int n = ItemMicroPart.getMaterialID((ye)ye3);
                MicroMaterialRegistry.IMicroMaterial iMicroMaterial = MicroMaterialRegistry.getMaterial((int)n);
                if (iMicroMaterial.isTransparent()) {
                    return false;
                }
                this.dropMaterial(uf2);
                this.material = n;
                this.world().a((double)this.x() + 0.5, (double)this.y() + 0.5, (double)this.z() + 0.5, iMicroMaterial.getSound().b(), (iMicroMaterial.getSound().c() + 1.0f) / 2.0f, iMicroMaterial.getSound().d() * 0.8f);
                this.sendMatUpdate();
                if (!uf2.bG.d) {
                    --ye3.b;
                }
            }
            return true;
        }
        if (ye3.d == ProjectRedCore.itemWireDebugger().cv) {
            ye3.a(1, (of)uf2);
            uf2.aV();
            return this.test(uf2);
        }
        return false;
    }

    static {
        double d = 0.25;
        FramedWirePart.boundingBoxes[6] = new Cuboid6(0.5 - d, 0.5 - d, 0.5 - d, 0.5 + d, 0.5 + d, 0.5 + d);
        for (int i = 0; i < 6; ++i) {
            FramedWirePart.boundingBoxes[i] = new Cuboid6(0.5 - d, 0.0, 0.5 - d, 0.5 + d, 0.5 - d, 0.5 + d).apply(Rotation.sideRotations[i].at(Vector3.center));
        }
    }
}

